/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.entity.SmallZombie;
import net.mobz.init.MobZEntities;

public class ZombieMage
extends SpellcasterIllager {
    private Sheep wololoTarget;

    public ZombieMage(EntityType<? extends SpellcasterIllager> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.zombie_mage.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.45).add(Attributes.ATTACK_DAMAGE, MobZ.configs.zombie_mage.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 20.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTargetOrWololoTarget());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SummonVexGoal());
        this.goalSelector.addGoal(5, (Goal)new ConjureFangsGoal());
        this.goalSelector.addGoal(6, (Goal)new WololoGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.zombie_mage.spawn && !this.isPatrolLeader() && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    public boolean canJoinRaid() {
        return super.canJoinRaid() && MobZ.configs.zombie_mage.can_join_raid.check((Raider)this);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
    }

    public boolean isAlliedTo(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (other instanceof SmallZombie) {
            return this.isAlliedTo(((SmallZombie)other).getOwner());
        }
        if (other instanceof LivingEntity && other.getType().is(EntityTypeTags.ILLAGER_FRIENDS)) {
            return this.getTeam() == null && other.getTeam() == null;
        }
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.EVOKER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.EVOKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.EVOKER_HURT;
    }

    private void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    @Nullable
    private Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel serverWorld, int wave, boolean p_37845_) {
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)ZombieMage.this);
        }

        public void tick() {
            if (ZombieMage.this.getTarget() != null) {
                ZombieMage.this.getLookControl().setLookAt((Entity)ZombieMage.this.getTarget(), (float)ZombieMage.this.getMaxHeadYRot(), (float)ZombieMage.this.getMaxHeadXRot());
            } else if (ZombieMage.this.getWololoTarget() != null) {
                ZombieMage.this.getLookControl().setLookAt((Entity)ZombieMage.this.getWololoTarget(), (float)ZombieMage.this.getMaxHeadYRot(), (float)ZombieMage.this.getMaxHeadXRot());
            }
        }
    }

    class SummonVexGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeVexPredicate;

        private SummonVexGoal() {
            super((SpellcasterIllager)ZombieMage.this);
            this.closeVexPredicate = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = ZombieMage.this.level().getNearbyEntities(SmallZombie.class, this.closeVexPredicate, (LivingEntity)ZombieMage.this, ZombieMage.this.getBoundingBox().inflate(16.0)).size();
            return ZombieMage.this.random.nextInt(8) + 1 > i;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            ServerLevel serverWorld = (ServerLevel)ZombieMage.this.level();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos = ZombieMage.this.blockPosition().offset(-2 + ZombieMage.this.random.nextInt(5), 1, -2 + ZombieMage.this.random.nextInt(5));
                SmallZombie SmallZombie2 = (SmallZombie)MobZEntities.SMALL_ZOMBIE.get().create(ZombieMage.this.level());
                SmallZombie2.moveTo(blockPos, 0.0f, 0.0f);
                SmallZombie2.finalizeSpawn((ServerLevelAccessor)serverWorld, ZombieMage.this.level().getCurrentDifficultyAt(blockPos), MobSpawnType.MOB_SUMMONED, null);
                SmallZombie2.setOwner(ZombieMage.this);
                SmallZombie2.setBounds(blockPos);
                SmallZombie2.setLifeTicks(20 * (30 + ZombieMage.this.random.nextInt(90)));
                ZombieMage.this.level().addFreshEntity((Entity)SmallZombie2);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class ConjureFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private ConjureFangsGoal() {
            super((SpellcasterIllager)ZombieMage.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected void performSpellCasting() {
            LivingEntity livingEntity = ZombieMage.this.getTarget();
            double d = Math.min(livingEntity.getY(), ZombieMage.this.getY());
            double e = Math.max(livingEntity.getY(), ZombieMage.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingEntity.getZ() - ZombieMage.this.getZ()), (double)(livingEntity.getX() - ZombieMage.this.getX()));
            if (ZombieMage.this.distanceToSqr((Entity)livingEntity) < 9.0) {
                float h;
                int j;
                for (j = 0; j < 5; ++j) {
                    h = f + (float)j * (float)Math.PI * 0.4f;
                    this.conjureFangs(ZombieMage.this.getX() + (double)Mth.cos((float)h) * 1.5, ZombieMage.this.getZ() + (double)Mth.sin((float)h) * 1.5, d, e, h, 0);
                }
                for (j = 0; j < 8; ++j) {
                    h = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(ZombieMage.this.getX() + (double)Mth.cos((float)h) * 2.5, ZombieMage.this.getZ() + (double)Mth.sin((float)h) * 2.5, d, e, h, 3);
                }
            } else {
                for (int j = 0; j < 16; ++j) {
                    double l = 1.25 * (double)(j + 1);
                    int m = 1 * j;
                    this.conjureFangs(ZombieMage.this.getX() + (double)Mth.cos((float)f) * l, ZombieMage.this.getZ() + (double)Mth.sin((float)f) * l, d, e, f, m);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float f, int warmup) {
            BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.below();
                BlockState blockState = ZombieMage.this.level().getBlockState(blockPos2);
                if (!blockState.isFaceSturdy((BlockGetter)ZombieMage.this.level(), blockPos2, Direction.UP)) continue;
                if (!ZombieMage.this.level().isEmptyBlock(blockPos) && !(voxelShape = (blockState2 = ZombieMage.this.level().getBlockState(blockPos)).getCollisionShape((BlockGetter)ZombieMage.this.level(), blockPos)).isEmpty()) {
                    d = voxelShape.max(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.below()).getY() >= Mth.floor((double)maxY) - 1);
            if (bl) {
                ZombieMage.this.level().addFreshEntity((Entity)new EvokerFangs(ZombieMage.this.level(), x, (double)blockPos.getY() + d, z, f, warmup, (LivingEntity)ZombieMage.this));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class WololoGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions purpleSheepPredicate;

        public WololoGoal() {
            super((SpellcasterIllager)ZombieMage.this);
            this.purpleSheepPredicate = TargetingConditions.forNonCombat().range(16.0).selector(sheepTarget -> ((Sheep)sheepTarget).getColor() == DyeColor.BLUE);
        }

        public boolean canUse() {
            if (ZombieMage.this.getTarget() != null) {
                return false;
            }
            if (ZombieMage.this.isCastingSpell()) {
                return false;
            }
            if (ZombieMage.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!ZombieMage.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            List list = ZombieMage.this.level().getNearbyEntities(Sheep.class, this.purpleSheepPredicate, (LivingEntity)ZombieMage.this, ZombieMage.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            ZombieMage.this.setWololoTarget((Sheep)list.get(ZombieMage.this.random.nextInt(list.size())));
            return true;
        }

        public boolean canContinueToUse() {
            return ZombieMage.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            ZombieMage.this.setWololoTarget(null);
        }

        protected void performSpellCasting() {
            Sheep sheepEntity = ZombieMage.this.getWololoTarget();
            if (sheepEntity != null && sheepEntity.isAlive()) {
                sheepEntity.setColor(DyeColor.RED);
            }
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_WOLOLO;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

