/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.mobz.MobZ;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class WildBoar
extends Pig {
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT, Items.POTATO, Items.BEETROOT});

    public WildBoar(EntityType<? extends Pig> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.wild_boar.life).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public LivingEntity getControllingPassenger() {
        return null;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.BOARSAYEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.BOARSAYEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.BOARDEATHEVENT.get();
    }

    public boolean isSaddled() {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public WildBoar getBreedOffspring(ServerLevel world, AgeableMob passiveEntity) {
        return (WildBoar)MobZEntities.WILD_BOAR.get().create((Level)world);
    }
}

