/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Wasp
extends PathfinderMob
implements FlyingAnimal {
    public static final int TICKS_PER_FLAP = Mth.ceil((float)1.4959966f);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Wasp.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private float rollAmount;
    private float rollAmountO;
    private int stayOutOfHiveCountdown;
    int remainingCooldownBeforeLocatingNewHive;
    private int underWaterTicks;
    @Nullable
    protected BlockPos hivePos;

    public Wasp(EntityType<? extends Wasp> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new LookControl((Mob)this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.4f, true));
        this.goalSelector.addGoal(8, (Goal)new BeeWanderGoal());
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public float getWalkTargetValue(BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.getBlockState(p_27788_).isAir() ? 10.0f : 0.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag p_27823_) {
        super.addAdditionalSaveData(p_27823_);
        if (this.hasHive()) {
            p_27823_.put("HivePos", NbtUtils.writeBlockPos((BlockPos)this.getHivePos()));
        }
    }

    public void readAdditionalSaveData(CompoundTag p_27793_) {
        this.hivePos = null;
        NbtUtils.readBlockPos((CompoundTag)p_27793_, (String)"HivePos").ifPresent(value -> {
            this.hivePos = value;
        });
        super.readAdditionalSaveData(p_27793_);
    }

    public boolean doHurtTarget(Entity p_27722_) {
        DamageSource damagesource = this.damageSources().sting((LivingEntity)this);
        boolean flag = p_27722_.hurt(this.damageSources().sting((LivingEntity)this), (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (flag) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)p_27722_, (DamageSource)damagesource);
            }
            if (p_27722_ instanceof LivingEntity) {
                ((LivingEntity)p_27722_).setStingerCount(((LivingEntity)p_27722_).getStingerCount() + 1);
                int i = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    i = 18;
                }
                if (i > 0) {
                    ((LivingEntity)p_27722_).addEffect(new MobEffectInstance(MobEffects.POISON, i * 20, 0), (Entity)this);
                }
            }
            this.playSound(SoundEvents.BEE_STING, 1.0f, 1.0f);
        }
        return flag;
    }

    public void tick() {
        super.tick();
        this.updateRollAmount();
    }

    void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.blockPosition();
        int j = (int)vec3.y - blockpos.getY();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.distManhattan((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.getPosTowards((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.navigation.setMaxVisitedNodesMultiplier(0.5f);
            this.navigation.moveTo(vec31.x, vec31.y, vec31.z, 1.0);
        }
    }

    boolean wantsToEnterHive() {
        if (this.stayOutOfHiveCountdown <= 0 && this.getTarget() == null) {
            boolean flag = this.level().isRaining() || this.level().isNight();
            return flag && !this.isHiveNearFire();
        }
        return false;
    }

    public void setStayOutOfHiveCountdown(int p_27916_) {
        this.stayOutOfHiveCountdown = p_27916_;
    }

    public float getRollAmount(float p_27936_) {
        return Mth.lerp((float)p_27936_, (float)this.rollAmountO, (float)this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    protected void customServerAiStep() {
        this.underWaterTicks = this.isInWaterOrBubble() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
    }

    private boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        BlockEntity blockentity = this.level().getBlockEntity(this.hivePos);
        return blockentity instanceof BeehiveBlockEntity && ((BeehiveBlockEntity)blockentity).isFireNearby();
    }

    private boolean doesHiveHaveSpace(BlockPos p_27885_) {
        BlockEntity blockentity = this.level().getBlockEntity(p_27885_);
        if (blockentity instanceof BeehiveBlockEntity) {
            return !((BeehiveBlockEntity)blockentity).isFull();
        }
        return false;
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    @Nullable
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    public GoalSelector getGoalSelector() {
        return this.goalSelector;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            boolean flag = this.getTarget() != null && this.getTarget().distanceToSqr((Entity)this) < 4.0;
            this.setRolling(flag);
            if (this.tickCount % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        BlockEntity blockentity = this.level().getBlockEntity(this.hivePos);
        return blockentity instanceof BeehiveBlockEntity;
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean p_27930_) {
        this.setFlag(2, p_27930_);
    }

    boolean isTooFarAway(BlockPos p_27890_) {
        return !this.closerThan(p_27890_, 32);
    }

    protected void setFlag(int p_27833_, boolean p_27834_) {
        if (p_27834_) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) | p_27833_)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) & ~p_27833_)));
        }
    }

    protected boolean getFlag(int p_27922_) {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & p_27922_) != 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)1.2f).add(Attributes.MOVEMENT_SPEED, (double)1.2f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected PathNavigation createNavigation(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean isStableDestination(BlockPos p_27947_) {
                return !Wasp.this.level().getBlockState(p_27947_.below()).isAir();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void playStepSound(BlockPos p_27820_, BlockState p_27821_) {
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource p_27845_) {
        return SoundEvents.BEE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BEE_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public boolean causeFallDamage(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void checkFallDamage(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean hurt(DamageSource p_27762_, float p_27763_) {
        if (this.isInvulnerableTo(p_27762_)) {
            return false;
        }
        return super.hurt(p_27762_, p_27763_);
    }

    protected void jumpInLiquid(TagKey<Fluid> p_27825_) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.2f));
    }

    boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.closerThan((Vec3i)this.blockPosition(), (double)p_27818_);
    }

    class BeeWanderGoal
    extends Goal {
        BeeWanderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return Wasp.this.navigation.isDone() && Wasp.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return Wasp.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                Wasp.this.navigation.moveTo(Wasp.this.navigation.createPath(BlockPos.containing((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3 = Wasp.this.getViewVector(0.0f);
            Vec3 vec32 = HoverRandomPos.getPos((PathfinderMob)Wasp.this, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.getPos((PathfinderMob)Wasp.this, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        }
    }
}

