/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.mobz.MathUtils;
import net.mobz.MobZ;
import net.mobz.entity.TadpoleEntity;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class ToadEntity
extends Animal {
    private static Set<Entity> targetedEntities = new HashSet<Entity>();
    private static final AttributeModifier JUMP_SPEED_BOOST_MOD = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"jump"), (double)0.6f, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Integer> TONGUE_ENTITY = SynchedEntityData.defineId(ToadEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean onGroundPrev;
    private int ticksUntilJump;
    public float tongueDistance;
    public float targetTongueDistance;
    public float mouthDistance = 0.0f;
    public int eatCooldown = 0;
    public boolean hasBaby;
    private final TargetingConditions predicate = TargetingConditions.forNonCombat().selector(e -> e.distanceTo((Entity)e) < 10.0f);

    public ToadEntity(EntityType<? extends ToadEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TONGUE_ENTITY, (Object)-1);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTongueTarget(this, this));
        this.goalSelector.addGoal(0, (Goal)new MakeTadpoleGoal(this, 1.0, 10));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(ToadEntity.getToadFoodTag()), false));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTongueEntity(LivingEntity e) {
        this.entityData.set(TONGUE_ENTITY, (Object)e.getId());
        if (this.level().isClientSide()) return;
        this.playSound(MobZSounds.TOAD_MOUTH.get(), 1.0f, 1.0f + (float)this.random.nextGaussian() / 5.0f);
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            targetedEntities.add((Entity)e);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean hasTongueEntity() {
        return (Integer)this.entityData.get(TONGUE_ENTITY) != -1;
    }

    @Nullable
    public Entity getTongueEntity() {
        return this.level().getEntity(((Integer)this.entityData.get(TONGUE_ENTITY)).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void clearTongueEntity() {
        Entity e;
        if (!this.level().isClientSide() && (e = this.getTongueEntity()) != null) {
            Class<ToadEntity> clazz = ToadEntity.class;
            // MONITORENTER : net.mobz.entity.ToadEntity.class
            targetedEntities.remove(e);
            // MONITOREXIT : clazz
        }
        this.entityData.set(TONGUE_ENTITY, (Object)-1);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        if (world.getBlockState(pos).is(Blocks.LILY_PAD)) {
            return 100.0f;
        }
        return super.getWalkTargetValue(pos, world);
    }

    private void dragVictim(LivingEntity victim) {
        if (this.isDeadOrDying() || this.isRemoved() || !this.hasLineOfSight((Entity)victim) || victim.isRemoved() || this.distanceTo((Entity)victim) > (float)(this.getSpotRange() * 2)) {
            this.clearTongueEntity();
            return;
        }
        if (this.isTongueReady()) {
            if (victim.getBoundingBox().intersects(this.getBoundingBox())) {
                this.attackVictim(victim);
            } else {
                double speed = this.getTongueSpeed2();
                double xx = MathUtils.approachValue(victim.position().x, this.getX(), speed);
                double yy = MathUtils.approachValue(victim.position().y, this.getY() + (double)0.2f, speed / 2.0);
                double zz = MathUtils.approachValue(victim.position().z, this.getZ(), speed);
                victim.absMoveTo(xx, yy, zz);
                victim.setDeltaMovement(0.0, 0.0, 0.0);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.hasBaby && this.getAge() == 0) {
            this.hasBaby = false;
        }
        if (this.hasTongueEntity()) {
            Entity e = this.getTongueEntity();
            if (e != null && !e.isPassenger()) {
                Vec3 victimCenter = e.getBoundingBox().getCenter();
                this.getLookControl().setLookAt(victimCenter.x, e.getY(), victimCenter.z, 100.0f, 100.0f);
                this.yBodyRot = this.getTargetYaw();
                this.yHeadRot = this.getTargetYaw();
                this.setXRot(this.getTargetPitch());
                float speed = this.getTongueSpeed();
                this.targetTongueDistance = this.distanceTo(e) - (float)(e.getBoundingBox().maxX - e.getBoundingBox().minX);
                this.targetTongueDistance = (float)this.getEyePosition().distanceTo(victimCenter);
                if (this.tongueDistance > this.targetTongueDistance) {
                    speed *= 2.0f;
                }
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, this.targetTongueDistance, speed);
                if ((double)Math.abs(this.tongueDistance - this.targetTongueDistance) < 0.001) {
                    this.dragVictim((LivingEntity)e);
                }
            } else {
                this.targetTongueDistance = 0.0f;
                this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
            }
        } else {
            this.targetTongueDistance = 0.0f;
            this.tongueDistance = MathUtils.approachValue(this.tongueDistance, 0.0f, 20.0f);
        }
    }

    public boolean isTongueReady() {
        float yaw = Math.abs((this.yBodyRot + 1.0f) % 360.0f - this.getTargetYaw());
        boolean dis = Math.abs(this.tongueDistance - this.targetTongueDistance) < 5.0f;
        return dis && (yaw < 4.0f || yaw >= 360.0f);
    }

    public float getTargetYaw() {
        double xx = this.lookControl.getWantedX() - this.getX();
        double zz = this.lookControl.getWantedZ() - this.getZ();
        return (float)(Mth.atan2((double)zz, (double)xx) * 57.2957763671875) - 90.0f;
    }

    public float getTargetPitch() {
        double xx = this.lookControl.getWantedX() - this.getX();
        double yy = this.lookControl.getWantedY() - this.getEyeY();
        double zz = this.lookControl.getWantedZ() - this.getZ();
        double sqrt = Math.sqrt(xx * xx + zz * zz);
        return (float)(-(Mth.atan2((double)yy, (double)sqrt) * 57.2957763671875));
    }

    public boolean canUseTongue() {
        return !this.isPassenger();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ToadEntity.getToadFoodTag());
    }

    public void customServerAiStep() {
        --this.eatCooldown;
        if (this.eatCooldown <= 0 && !this.hasTongueEntity()) {
            double spotRange = this.getSpotRange();
            List targets = this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.getBoundingBox().inflate(spotRange, spotRange, spotRange), this::isToadTarget);
            LivingEntity closest = this.level().getNearestEntity(targets, this.predicate, (LivingEntity)this, this.getX(), this.getY(), this.getZ());
            if (!this.canUseTongue() || closest == null || closest.isPassenger() || targets.isEmpty()) {
                this.clearTongueEntity();
            } else {
                this.eatCooldown = 100;
                this.setTongueEntity(closest);
            }
        } else {
            Entity e = this.getTongueEntity();
            if (!this.canUseTongue() || e == null || !e.isAlive()) {
                this.clearTongueEntity();
            }
        }
        if (this.ticksUntilJump > 0) {
            --this.ticksUntilJump;
        }
        if (this.ticksUntilJump <= 0 && this.moveControl.hasWanted()) {
            this.ticksUntilJump = this.random.nextInt(80) + 20;
            this.jumpFromGround();
            AttributeInstance entityAttributeInstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            entityAttributeInstance.removeModifier(JUMP_SPEED_BOOST_MOD);
            entityAttributeInstance.addTransientModifier(JUMP_SPEED_BOOST_MOD);
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
        if (this.onGround() && !this.onGroundPrev) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(JUMP_SPEED_BOOST_MOD);
        }
        this.onGroundPrev = this.onGround();
    }

    protected SoundEvent getJumpSound() {
        return MobZSounds.TOAD_JUMP.get();
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.toad.life).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("HasBaby", this.hasBaby);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.hasBaby = tag.getBoolean("HasBaby");
    }

    public void setHasBaby(boolean hasBaby) {
        this.hasBaby = hasBaby;
    }

    public void spawnChildFromBreeding(ServerLevel serverWorld, Animal other) {
        ServerPlayer player = this.getLoveCause();
        if (player == null && other.getLoveCause() != null) {
            player = other.getLoveCause();
        }
        if (player != null) {
            player.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(player, (Animal)this, other, null);
        }
        this.setHasBaby(true);
        this.setAge(6000);
        other.setAge(6000);
        this.resetLove();
        other.resetLove();
        serverWorld.broadcastEntityEvent((Entity)this, (byte)18);
        if (serverWorld.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            serverWorld.addFreshEntity((Entity)new ExperienceOrb((Level)serverWorld, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.TOAD_CROAK.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.TOAD_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return MobZSounds.TOAD_HURT.get();
    }

    public float getVoicePitch() {
        return super.getVoicePitch() + (float)this.random.nextGaussian() / 8.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToadTarget(Entity entity) {
        if (!this.canToadTarget((LivingEntity)entity) || !this.hasLineOfSight(entity)) {
            return false;
        }
        Class<ToadEntity> clazz = ToadEntity.class;
        synchronized (ToadEntity.class) {
            double FOV;
            double diff;
            double dz;
            double dx;
            double dir;
            if (targetedEntities.contains(entity)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            double headingAngle = this.getYHeadRot() + 90.0f;
            if (headingAngle > 360.0) {
                headingAngle -= 360.0;
            }
            if (headingAngle < 0.0) {
                headingAngle += 360.0;
            }
            if ((dir = 90.0 - Mth.atan2((double)(dx = entity.getX() - this.getX()), (double)(dz = entity.getZ() - this.getZ())) / 3.1415927410125732 * 180.0) > 360.0) {
                dir -= 360.0;
            }
            if (dir < 0.0) {
                dir += 360.0;
            }
            return (diff = dir - headingAngle) < (FOV = 90.0) / 2.0 && diff > -FOV / 2.0;
        }
    }

    public static TagKey<Item> getToadFoodTag() {
        return MobZ.TOAD_FOOD_TAG;
    }

    public boolean canToadTarget(LivingEntity entity) {
        return entity.getType().is(MobZ.TOAD_TARGET_TAG);
    }

    public void attackVictim(LivingEntity victim) {
        if (victim instanceof Player) {
            victim.hurt(this.damageSources().mobProjectile((Entity)this, null), 1.0f);
        } else {
            victim.hurt(this.damageSources().mobProjectile((Entity)this, null), Float.MAX_VALUE);
        }
    }

    public int getSpotRange() {
        return 5;
    }

    protected float getTongueSpeed() {
        return 0.8f;
    }

    protected float getTongueSpeed2() {
        return 0.4f;
    }

    private class LookAtTongueTarget
    extends Goal {
        private final ToadEntity toad;

        public LookAtTongueTarget(ToadEntity toadEntity, ToadEntity entity) {
            this.toad = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.toad.hasTongueEntity();
        }

        public boolean canContinueToUse() {
            return this.toad.hasTongueEntity();
        }
    }

    public class MakeTadpoleGoal
    extends MoveToBlockGoal {
        private final ToadEntity toad;

        public MakeTadpoleGoal(ToadEntity toad, double speed, int range) {
            super((PathfinderMob)toad, speed, range, 5);
            this.toad = toad;
        }

        public boolean canUse() {
            return this.toad.hasBaby && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.toad.hasBaby;
        }

        public void tick() {
            super.tick();
            BlockPos blockPos = this.mob.blockPosition();
            if (this.getMoveToTarget().closerToCenterThan((Position)this.toad.position(), 2.0)) {
                ToadEntity.this.getNavigation().moveTo((double)((float)blockPos.getX() + 0.5f), (double)blockPos.getY(), (double)((float)blockPos.getZ() + 0.5f), 1.0);
            }
            if (this.toad.isInWater()) {
                ServerLevel world = (ServerLevel)this.toad.level();
                this.toad.setHasBaby(false);
                TadpoleEntity tadpole = (TadpoleEntity)MobZEntities.TADPOLE.get().create((Level)world);
                if (tadpole != null) {
                    world.playSound(null, blockPos, MobZSounds.TOAD_HAVE_BABY.get(), SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
                    tadpole.setBaby(true);
                    tadpole.moveTo(this.toad.getX(), this.toad.getY(), this.toad.getZ(), 0.0f, 0.0f);
                    world.addFreshEntityWithPassengers((Entity)tadpole);
                }
            }
        }

        public double acceptedDistance() {
            return 0.0;
        }

        protected boolean isValidTarget(LevelReader world, BlockPos pos) {
            FluidState state = world.getFluidState(pos);
            return state.isSource() && state.is(FluidTags.WATER) && world.getBlockState(pos.above()).isAir();
        }
    }
}

