/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class TinySpider
extends Spider {
    public TinySpider(EntityType<? extends Spider> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.tiny_spider.life).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, MobZ.configs.tiny_spider.attack);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        BlockPos posentity = this.blockPosition();
        return MobZ.configs.tiny_spider.spawn && this.level().getMaxLocalRawBrightness(posentity) <= 7 && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.1f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.NOTHINGEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return MobZSounds.NOTHINGEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.NOTHINGEVENT.get();
    }
}

