/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class TankZombie
extends Zombie {
    public TankZombie(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.tank_zombie.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, MobZ.configs.tank_zombie.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.5).add(Attributes.ATTACK_KNOCKBACK, 1.2).add(Attributes.ARMOR, 3.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public boolean isUnderWaterConverting() {
        return false;
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.tank_zombie.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    public boolean doHurtTarget(Entity victim) {
        boolean flag = super.doHurtTarget(victim);
        if (flag && victim instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)victim;
            if (!this.level().isClientSide) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0, false, false));
            }
        }
        return flag;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.AMBIENTTANKEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.HURTTANKEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.DEATHTANKEVENT.get();
    }

    protected SoundEvent getStepSound() {
        return MobZSounds.STEPTANKEVENT.get();
    }

    public boolean isBaby() {
        return false;
    }
}

