/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.entity.SmallSpider;
import net.mobz.init.MobZEntities;
import net.mobz.init.MobZSounds;

public class SpiderMage
extends SpellcasterIllager {
    private Sheep wololoTarget;

    public SpiderMage(EntityType<? extends SpiderMage> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.spider_mage.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.45).add(Attributes.ATTACK_DAMAGE, MobZ.configs.spider_mage.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 20.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTargetOrWololoTarget());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SummonSpider());
        this.goalSelector.addGoal(5, (Goal)new ConjureFangsGoal());
        this.goalSelector.addGoal(6, (Goal)new WololoGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean canJoinRaid() {
        return super.canJoinRaid() && MobZ.configs.spider_mage.can_join_raid.check((Raider)this);
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.spider_mage.spawn && !this.isPatrolLeader() && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public boolean isAlliedTo(Entity entity_1) {
        if (entity_1 == null) {
            return false;
        }
        if (entity_1 == this) {
            return true;
        }
        if (super.isAlliedTo(entity_1)) {
            return true;
        }
        return entity_1 instanceof SmallSpider;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.EVEIDLEEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.EVEDEATHEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.EVEHURTEVENT.get();
    }

    private void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    @Nullable
    private Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel serverWorld, int wave, boolean p_37845_) {
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)SpiderMage.this);
        }

        public void tick() {
            if (SpiderMage.this.getTarget() != null) {
                SpiderMage.this.getLookControl().setLookAt((Entity)SpiderMage.this.getTarget(), (float)SpiderMage.this.getMaxHeadYRot(), (float)SpiderMage.this.getMaxHeadXRot());
            } else if (SpiderMage.this.getWololoTarget() != null) {
                SpiderMage.this.getLookControl().setLookAt((Entity)SpiderMage.this.getWololoTarget(), (float)SpiderMage.this.getMaxHeadYRot(), (float)SpiderMage.this.getMaxHeadXRot());
            }
        }
    }

    class SummonSpider
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeVexPredicate;

        private SummonSpider() {
            super((SpellcasterIllager)SpiderMage.this);
            this.closeVexPredicate = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = SpiderMage.this.level().getNearbyEntities(SmallSpider.class, this.closeVexPredicate, (LivingEntity)SpiderMage.this, SpiderMage.this.getBoundingBox().inflate(16.0)).size();
            return SpiderMage.this.random.nextInt(8) + 1 > i;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            ServerLevel serverWorld = (ServerLevel)SpiderMage.this.level();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos = SpiderMage.this.blockPosition().offset(-2 + SpiderMage.this.random.nextInt(5), 1, -2 + SpiderMage.this.random.nextInt(5));
                SmallSpider vexEntity = (SmallSpider)MobZEntities.SMALL_SPIDER.get().create(SpiderMage.this.level());
                vexEntity.moveTo(blockPos, 0.0f, 0.0f);
                vexEntity.finalizeSpawn((ServerLevelAccessor)serverWorld, SpiderMage.this.level().getCurrentDifficultyAt(blockPos), MobSpawnType.MOB_SUMMONED, null);
                vexEntity.setLifeTicks(20 * (30 + SpiderMage.this.random.nextInt(90)));
                SpiderMage.this.level().addFreshEntity((Entity)vexEntity);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class ConjureFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private ConjureFangsGoal() {
            super((SpellcasterIllager)SpiderMage.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected void performSpellCasting() {
            LivingEntity livingEntity = SpiderMage.this.getTarget();
            double d = Math.min(livingEntity.getY(), SpiderMage.this.getY());
            double e = Math.max(livingEntity.getY(), SpiderMage.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingEntity.getZ() - SpiderMage.this.getZ()), (double)(livingEntity.getX() - SpiderMage.this.getX()));
            if (SpiderMage.this.distanceToSqr((Entity)livingEntity) < 9.0) {
                float h;
                int j;
                for (j = 0; j < 5; ++j) {
                    h = f + (float)j * (float)Math.PI * 0.4f;
                    this.conjureFangs(SpiderMage.this.getX() + (double)Mth.cos((float)h) * 1.5, SpiderMage.this.getZ() + (double)Mth.sin((float)h) * 1.5, d, e, h, 0);
                }
                for (j = 0; j < 8; ++j) {
                    h = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(SpiderMage.this.getX() + (double)Mth.cos((float)h) * 2.5, SpiderMage.this.getZ() + (double)Mth.sin((float)h) * 2.5, d, e, h, 3);
                }
            } else {
                for (int j = 0; j < 16; ++j) {
                    double l = 1.25 * (double)(j + 1);
                    int m = 1 * j;
                    this.conjureFangs(SpiderMage.this.getX() + (double)Mth.cos((float)f) * l, SpiderMage.this.getZ() + (double)Mth.sin((float)f) * l, d, e, f, m);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float f, int warmup) {
            BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.below();
                BlockState blockState = SpiderMage.this.level().getBlockState(blockPos2);
                if (!blockState.isFaceSturdy((BlockGetter)SpiderMage.this.level(), blockPos2, Direction.UP)) continue;
                if (!SpiderMage.this.level().isEmptyBlock(blockPos) && !(voxelShape = (blockState2 = SpiderMage.this.level().getBlockState(blockPos)).getCollisionShape((BlockGetter)SpiderMage.this.level(), blockPos)).isEmpty()) {
                    d = voxelShape.max(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.below()).getY() >= Mth.floor((double)maxY) - 1);
            if (bl) {
                SpiderMage.this.level().addFreshEntity((Entity)new EvokerFangs(SpiderMage.this.level(), x, (double)blockPos.getY() + d, z, f, warmup, (LivingEntity)SpiderMage.this));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class WololoGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions purpleSheepPredicate;

        public WololoGoal() {
            super((SpellcasterIllager)SpiderMage.this);
            this.purpleSheepPredicate = TargetingConditions.forNonCombat().range(16.0).selector(sheepTarget -> ((Sheep)sheepTarget).getColor() == DyeColor.BLUE);
        }

        public boolean canUse() {
            if (SpiderMage.this.getTarget() != null) {
                return false;
            }
            if (SpiderMage.this.isCastingSpell()) {
                return false;
            }
            if (SpiderMage.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            if (!SpiderMage.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            List list = SpiderMage.this.level().getNearbyEntities(Sheep.class, this.purpleSheepPredicate, (LivingEntity)SpiderMage.this, SpiderMage.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            SpiderMage.this.setWololoTarget((Sheep)list.get(SpiderMage.this.random.nextInt(list.size())));
            return true;
        }

        public boolean canContinueToUse() {
            return SpiderMage.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            SpiderMage.this.setWololoTarget(null);
        }

        protected void performSpellCasting() {
            Sheep sheepEntity = SpiderMage.this.getWololoTarget();
            if (sheepEntity != null && sheepEntity.isAlive()) {
                sheepEntity.setColor(DyeColor.RED);
            }
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_WOLOLO;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

