/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mobz.MobZ;
import net.mobz.init.MobZItems;
import net.mobz.init.MobZWeapons;

public class PillagerBoss
extends Pillager {
    private int cooldown = 0;

    public PillagerBoss(EntityType<PillagerBoss> entityType_1, Level world_1) {
        super(entityType_1, world_1);
        this.xpReward = 50;
        ItemStack itemStack = new ItemStack((ItemLike)MobZWeapons.ARMORED_SWORD.get());
        ItemStack itemStack2 = new ItemStack((ItemLike)MobZItems.PILLAGER_STAFF.get());
        this.setItemSlot(EquipmentSlot.MAINHAND, itemStack2);
        this.setItemSlot(EquipmentSlot.OFFHAND, itemStack);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.pillager_boss.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, MobZ.configs.pillager_boss.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
    }

    protected void customServerAiStep() {
        int requiredCooldown;
        MobEffectInstance slow = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 0, false, false);
        int n = requiredCooldown = this.level().getDifficulty() == Difficulty.HARD ? MobZ.configs.pillager_boss.wither_attack_cooldown_hard : MobZ.configs.pillager_boss.wither_attack_cooldown;
        if (this.getTarget() != null && !this.level().isClientSide && this.distanceToSqr((Entity)this.getTarget()) < 4096.0 && this.hasLineOfSight((Entity)this.getTarget())) {
            ++this.cooldown;
            if (this.cooldown >= requiredCooldown) {
                this.cooldown = 0;
                this.performRangedAttack(this.getTarget(), 1.0f);
            }
            if (this.cooldown >= requiredCooldown - 20) {
                this.getTarget().addEffect(slow);
            }
        } else {
            this.cooldown = 0;
        }
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public void performRangedAttack(LivingEntity target, float f) {
        Vec3 vec3d_1 = this.getViewVector(1.0f);
        double double_3 = target.getX() - (this.getX() + vec3d_1.x * 2.0);
        double double_4 = this.getY() - target.getBoundingBox().getYsize() + (double)(target.getBbHeight() / 2.0f) - (0.5 + this.getY() + (double)(this.getBbHeight() / 2.0f)) + 1.0;
        double double_5 = target.getZ() - (this.getZ() + vec3d_1.z * 2.0);
        double double_9 = this.getY() - target.getBoundingBox().getYsize() + (double)(target.getBbHeight() / 2.0f) - (0.5 + this.getY() + (double)(this.getBbHeight() / 2.0f)) + 0.7;
        double double_10 = target.getZ() - (this.getZ() + vec3d_1.z * 2.0) + 0.7;
        double double_11 = target.getZ() - (this.getZ() + vec3d_1.z * 2.0) - 0.7;
        WitherSkull skull1 = new WitherSkull(this.level(), (LivingEntity)this, new Vec3(double_3, double_4, double_5));
        WitherSkull skull2 = new WitherSkull(this.level(), (LivingEntity)this, new Vec3(double_3, double_9, double_10));
        WitherSkull skull3 = new WitherSkull(this.level(), (LivingEntity)this, new Vec3(double_3, double_9, double_11));
        double double_6 = this.getX() + vec3d_1.x * 2.0;
        double double_7 = this.getY() + (double)this.getBbHeight();
        double double_8 = this.getZ() + vec3d_1.z * 2.0;
        skull1.setPosRaw(double_6, double_7, double_8);
        skull2.setPosRaw(double_6, double_7, double_8);
        skull3.setPosRaw(double_6, double_7, double_8);
        this.level().addFreshEntity((Entity)skull1);
        this.level().addFreshEntity((Entity)skull2);
        this.level().addFreshEntity((Entity)skull3);
    }

    public boolean canJoinRaid() {
        return super.canJoinRaid() && MobZ.configs.pillager_boss.can_join_raid.check((Raider)this);
    }

    protected void dropCustomDeathLoot(ServerLevel serverWorld, DamageSource damageSource, boolean flag) {
    }
}

