/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class Pigman
extends Piglin {
    public Pigman(EntityType<? extends Piglin> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.pigman.attack * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.KNOCKBACK_RESISTANCE, 1.5).add(Attributes.ATTACK_DAMAGE, MobZ.configs.pigman.attack * MobZ.configs.damage_multiplier);
    }

    protected boolean canAddToInventory(ItemStack stack) {
        return false;
    }

    public boolean isBaby() {
        return true;
    }

    public boolean isImmuneToZombification() {
        return false;
    }

    public boolean canPickUpLoot() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.SAYPIGEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.HURTPIGEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.DEATHPIGEVENT.get();
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.pigman.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }
}

