/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class NetherWolf
extends Wolf {
    public NetherWolf(EntityType<? extends Wolf> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.nether_wolf.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, MobZ.configs.nether_wolf.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public boolean isFood(ItemStack itemStack_1) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.WGROWLEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return MobZSounds.WHURTEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.WDEATHEVENT.get();
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        BlockPos posentity = this.blockPosition();
        return MobZ.configs.nether_wolf.spawn && this.level().getMaxLocalRawBrightness(posentity) <= 10 && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }
}

