/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.LavaGolem;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class NetherSkeleton
extends Skeleton {
    public NetherSkeleton(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.nether_skeleton.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.SKELISAYEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.SKELIHURTEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.SKELIDEATHEVENT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            this.playSound(MobZSounds.SKELISTEPEVENT.get(), 0.15f, 1.0f);
        }
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{LavaGolem.class}));
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.nether_skeleton.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }
}

