/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OfferFlowerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.DefendVillageTargetGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.attack.GolemAttack;
import net.mobz.init.MobZItems;
import net.mobz.init.MobZSounds;

public class MetalGolem
extends IronGolem {
    public MetalGolem(EntityType<? extends IronGolem> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 25;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.metal_golem.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.5).add(Attributes.ATTACK_DAMAGE, MobZ.configs.metal_golem.attack * MobZ.configs.damage_multiplier);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GolemAttack(this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 36.0f));
        this.goalSelector.addGoal(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.8, false));
        this.goalSelector.addGoal(3, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.9, false, 10, () -> false));
        this.goalSelector.addGoal(5, (Goal)new OfferFlowerGoal((IronGolem)this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.65));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new DefendVillageTargetGoal((IronGolem)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper)));
    }

    public boolean hurt(DamageSource source, float amount) {
        Crackiness.Level crack = this.getCrackiness();
        boolean bl = super.hurt(source, amount);
        if (bl && this.getCrackiness() != crack) {
            this.playSound(MobZSounds.MGOLEMBREAKEVENT.get(), 1.0f, 1.0f);
        }
        return bl;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.MGOLEMHITEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.GOLEMDEATHEVENT.get();
    }

    protected void playStepSound(BlockPos blockPos_1, BlockState blockState_1) {
        this.playSound(MobZSounds.GOLEMWALKEVENT.get(), 1.0f, 1.0f);
    }

    public boolean removeWhenFarAway(double double_1) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.metal_golem.enabled;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is((Item)MobZItems.HARDENEDMETAL_INGOT.get())) {
            return InteractionResult.PASS;
        }
        float f = this.getHealth();
        this.heal(40.0f);
        if (this.getHealth() == f) {
            return InteractionResult.PASS;
        }
        float g = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, g);
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }
}

