/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;
import net.mobz.init.MobZWeapons;

public class LostSkeleton
extends Skeleton {
    public LostSkeleton(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.lost_skeleton.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.255).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_DAMAGE, MobZ.configs.lost_skeleton.attack * MobZ.configs.damage_multiplier);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MobZWeapons.STONE_TOMAHAWK.get()));
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.SKELASAYEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.SKELAHURTEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.SKELADEATHEVENT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            this.playSound(MobZSounds.SKELASTEPEVENT.get(), 0.15f, 1.0f);
        }
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.lost_skeleton.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }
}

