/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.Blackbear;
import net.mobz.entity.Boar;
import net.mobz.entity.FrostBlaze;
import net.mobz.entity.FrostCreeper;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.entity.attack.GolemAttack;
import net.mobz.init.MobZSounds;

public class IceGolem
extends IronGolem {
    public IceGolem(EntityType<? extends IronGolem> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.ice_golem.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.ATTACK_DAMAGE, MobZ.configs.ice_golem.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GolemAttack(this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.initCustomGoals();
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        BlockPos posentity = this.blockPosition();
        return MobZ.configs.ice_golem.spawn && this.level().getCurrentDifficultyAt(posentity).getDifficulty() != Difficulty.PEACEFUL && this.level().isDay() && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    protected void initCustomGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Zombie.class}));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Skeleton.class}));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Spider.class}));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Creeper.class}));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Slime.class}));
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{FrostBlaze.class}));
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{FrostCreeper.class}));
        this.targetSelector.addGoal(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Boar.class}));
        this.targetSelector.addGoal(9, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Blackbear.class}));
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.GOLEMHITEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.GOLEMDEATHEVENT.get();
    }

    protected void playStepSound(BlockPos blockPos_1, BlockState blockState_1) {
        this.playSound(MobZSounds.GOLEMWALKEVENT.get(), 1.0f, 1.0f);
    }

    public boolean removeWhenFarAway(double double_1) {
        return true;
    }
}

