/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mobz.MobZ;
import net.mobz.init.MobZEntities;

public class GoldenChicken
extends Chicken {
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_NUGGET});
    public float field_6741;
    public float field_6743;
    public float field_6738;
    public float field_6736;
    public float field_6737 = 1.0f;
    public int eggLayTime = this.random.nextInt(6000) + 6000;
    public boolean jockey;

    public GoldenChicken(EntityType<? extends GoldenChicken> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.golden_chicken.life).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.924f : 1.0f;
    }

    public void aiStep() {
        super.aiStep();
        this.field_6736 = this.field_6741;
        this.field_6738 = this.field_6743;
        this.field_6743 = (float)((double)this.field_6743 + (double)(this.onGround() ? -1 : 4) * 0.3);
        this.field_6743 = Mth.clamp((float)this.field_6743, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.field_6737 < 1.0f) {
            this.field_6737 = 1.0f;
        }
        this.field_6737 = (float)((double)this.field_6737 * 0.9);
        Vec3 vec3d_1 = this.getDeltaMovement();
        if (!this.onGround() && vec3d_1.y < 0.0) {
            this.setDeltaMovement(vec3d_1.multiply(1.0, 0.6, 1.0));
        }
        this.field_6741 += this.field_6737 * 2.0f;
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && !this.isChickenJockey() && --this.eggTime <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)Items.GOLD_NUGGET);
            this.eggTime = this.random.nextInt(6000) + 6000;
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CHICKEN_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return SoundEvents.CHICKEN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CHICKEN_DEATH;
    }

    protected void playStepSound(BlockPos blockPos_1, BlockState blockState_1) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    public GoldenChicken getBreedOffspring(ServerLevel world, AgeableMob passiveEntity_1) {
        return (GoldenChicken)MobZEntities.GOLDEN_CHICKEN.get().create((Level)world);
    }

    public boolean isFood(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag_1) {
        super.addAdditionalSaveData(compoundTag_1);
        compoundTag_1.putBoolean("IsChickenJockey", this.isChickenJockey);
        compoundTag_1.putInt("EggLayTime", this.eggTime);
    }

    public boolean removeWhenFarAway(double double_1) {
        return false;
    }

    public boolean isChickenJockey() {
        return false;
    }
}

