/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.entity.attack.FrostballEntity;
import net.mobz.init.MobZSounds;

public class FrostBlaze
extends Blaze {
    private float field_7214 = 0.5f;
    private int field_7215;
    private static final EntityDataAccessor<Byte> BLAZE_FLAGS = SynchedEntityData.defineId(FrostBlaze.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public FrostBlaze(EntityType<? extends FrostBlaze> entityType_1, Level world_1) {
        super(entityType_1, world_1);
        this.setPathfindingMalus(PathType.WATER, 8.0f);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.frost_blaze.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, MobZ.configs.frost_blaze.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.frost_blaze.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new ShootFireballGoal(this));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLAZE_FLAGS, (Object)0);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SNOW_GOLEM_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.level().isClientSide) {
            if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, MobZSounds.NOTHINGEVENT.get(), this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int int_1 = 0; int_1 < 2; ++int_1) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        LivingEntity livingEntity_1;
        --this.field_7215;
        if (this.field_7215 <= 0) {
            this.field_7215 = 100;
            this.field_7214 = 0.5f + (float)this.random.nextGaussian() * 3.0f;
        }
        if ((livingEntity_1 = this.getTarget()) != null && livingEntity_1.getEyeY() > this.getEyeY() + (double)this.field_7214 && this.canAttack(livingEntity_1)) {
            Vec3 vec3d_1 = this.getDeltaMovement();
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, ((double)0.3f - vec3d_1.y) * (double)0.3f, 0.0));
            this.hasImpulse = true;
        }
        super.customServerAiStep();
    }

    public boolean causeFallDamage(float float_1, float float_2, DamageSource source) {
        return false;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isOnFire() {
        return this.isCharged();
    }

    private boolean isCharged() {
        return ((Byte)this.entityData.get(BLAZE_FLAGS) & 1) != 0;
    }

    private void setCharged(boolean boolean_1) {
        byte byte_1 = (Byte)this.entityData.get(BLAZE_FLAGS);
        byte_1 = boolean_1 ? (byte)(byte_1 | 1) : (byte)(byte_1 & 0xFFFFFFFE);
        this.entityData.set(BLAZE_FLAGS, (Object)byte_1);
    }

    public void attack(LivingEntity target, float f) {
        Snowball snowballEntity = new Snowball(this.level(), (LivingEntity)this);
        double d = target.getEyeY() - (double)1.1f;
        double e = target.getX() - this.getX();
        double g = d - snowballEntity.getY();
        double h = target.getZ() - this.getZ();
        double i = Math.sqrt(e * e + h * h) * (double)0.2f;
        snowballEntity.shoot(e, g + i, h, 1.6f, 12.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)snowballEntity);
    }

    static class ShootFireballGoal
    extends Goal {
        private final FrostBlaze blaze;
        private int field_7218;
        private int field_7217;
        private int field_19420;

        public ShootFireballGoal(FrostBlaze blazeEntity_1) {
            this.blaze = blazeEntity_1;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingEntity_1 = this.blaze.getTarget();
            return livingEntity_1 != null && livingEntity_1.isAlive() && this.blaze.canAttack(livingEntity_1);
        }

        public void start() {
            this.field_7218 = 0;
        }

        public void stop() {
            this.blaze.setCharged(false);
            this.field_19420 = 0;
        }

        public void tick() {
            --this.field_7217;
            LivingEntity livingEntity_1 = this.blaze.getTarget();
            if (livingEntity_1 != null) {
                boolean boolean_1 = this.blaze.getSensing().hasLineOfSight((Entity)livingEntity_1);
                this.field_19420 = boolean_1 ? 0 : ++this.field_19420;
                double double_1 = this.blaze.distanceToSqr((Entity)livingEntity_1);
                if (double_1 < 4.0) {
                    if (!boolean_1) {
                        return;
                    }
                    if (this.field_7217 <= 0) {
                        this.field_7217 = 20;
                        this.blaze.doHurtTarget((Entity)livingEntity_1);
                    }
                    this.blaze.getMoveControl().setWantedPosition(livingEntity_1.getX(), livingEntity_1.getY(), livingEntity_1.getZ(), 1.0);
                } else if (double_1 < this.method_6995() * this.method_6995() && boolean_1) {
                    double double_2 = livingEntity_1.getX() - this.blaze.getX();
                    double double_3 = livingEntity_1.getY(0.5) - this.blaze.getY(0.5);
                    double double_4 = livingEntity_1.getZ() - this.blaze.getZ();
                    if (this.field_7217 <= 0) {
                        ++this.field_7218;
                        if (this.field_7218 == 1) {
                            this.field_7217 = 60;
                            this.blaze.setCharged(true);
                        } else if (this.field_7218 <= 4) {
                            this.field_7217 = 6;
                        } else {
                            this.field_7217 = 100;
                            this.field_7218 = 0;
                            this.blaze.setCharged(false);
                        }
                        if (this.field_7218 > 1) {
                            double float_1 = Math.sqrt(Math.sqrt(double_1)) * 0.5;
                            this.blaze.level().levelEvent((Player)null, 1018, this.blaze.blockPosition(), 0);
                            for (int fireCount = 0; fireCount < 1; ++fireCount) {
                                Vec3 displacementVector = new Vec3(double_2 + this.blaze.getRandom().nextGaussian() * float_1, double_3, double_4 + this.blaze.getRandom().nextGaussian() * float_1);
                                FrostballEntity bullet = new FrostballEntity(this.blaze.level(), (LivingEntity)this.blaze, displacementVector.normalize());
                                bullet.setPos(bullet.getX(), this.blaze.getY(0.5) + 0.5, bullet.getZ());
                                this.blaze.level().addFreshEntity((Entity)bullet);
                            }
                        }
                    }
                    this.blaze.getLookControl().setLookAt((Entity)livingEntity_1, 10.0f, 10.0f);
                } else if (this.field_19420 < 5) {
                    this.blaze.getMoveControl().setWantedPosition(livingEntity_1.getX(), livingEntity_1.getY(), livingEntity_1.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double method_6995() {
            return this.blaze.getAttribute(Attributes.FOLLOW_RANGE).getValue();
        }
    }
}

