/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.init.MobZSounds;
import net.mobz.init.MobZWeapons;

public abstract class FriendEntity
extends TamableAnimal
implements NeutralMob {
    public FriendEntity(EntityType<? extends FriendEntity> entityType, Level world) {
        super(entityType, world);
        this.setTame(false, false);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MobZWeapons.ARMORED_SWORD.get()));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(MobZSounds.LEATHERWALKEVENT.get(), 0.15f, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.NOTHINGEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PLAYER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.level().isClientSide) {
            boolean bl = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isTameItem(itemStack) && !this.isTame() && !this.isAngry();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(itemStack) && this.getHealth() < this.getMaxHealth()) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                this.heal(MobZ.platform.getFoodProperties(itemStack, (LivingEntity)player).nutrition());
                return InteractionResult.SUCCESS;
            }
            if (this.canEquipItemFromPlayer(itemStack)) {
                ItemStack newStack = itemStack.copy();
                this.setItemSlot(EquipmentSlot.OFFHAND, newStack);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(player, hand);
            if (this.isOwnedBy((LivingEntity)player)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (this.isTameItem(itemStack) && !this.isAngry()) {
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public FriendEntity getBreedOffspring(ServerLevel world, AgeableMob passiveEntity) {
        FriendEntity FriendEntity2 = (FriendEntity)this.getType().create((Level)world);
        UUID uUID = this.getOwnerUUID();
        if (uUID != null) {
            FriendEntity2.setOwnerUUID(uUID);
            FriendEntity2.setTame(true, false);
        }
        return FriendEntity2;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof FriendEntity) {
                FriendEntity FriendEntity2 = (FriendEntity)target;
                return !FriendEntity2.isTame() || FriendEntity2.getOwner() != owner;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).canHarmPlayer((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).isTamed()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).isTame();
        }
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public abstract boolean isFood(ItemStack var1);

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int ticks) {
    }

    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(UUID uuid) {
    }

    public void startPersistentAngerTimer() {
    }

    protected abstract boolean isTameItem(ItemStack var1);

    protected abstract boolean canEquipItemFromPlayer(ItemStack var1);

    public static class FioraEntity
    extends FriendEntity {
        public FioraEntity(EntityType<? extends FioraEntity> entityType, Level level) {
            super(entityType, level);
        }

        public static AttributeSupplier.Builder createMobzAttributes() {
            return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.MAX_HEALTH, MobZ.configs.fiora.life).add(Attributes.ATTACK_DAMAGE, MobZ.configs.fiora.attack);
        }

        @Override
        public boolean isFood(ItemStack stack) {
            return stack.is(MobZ.FIORA_FOOD_TAG);
        }

        @Override
        protected boolean isTameItem(ItemStack stack) {
            return stack.is(MobZ.FIORA_TAME_TAG);
        }

        @Override
        protected boolean canEquipItemFromPlayer(ItemStack stack) {
            return stack.is(MobZ.FIORA_EQUIP_TAG);
        }
    }

    public static class KatherineEntity
    extends FriendEntity {
        public KatherineEntity(EntityType<? extends KatherineEntity> entityType, Level world) {
            super(entityType, world);
        }

        public static AttributeSupplier.Builder createMobzAttributes() {
            return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.MAX_HEALTH, MobZ.configs.katherine.life).add(Attributes.ATTACK_DAMAGE, MobZ.configs.katherine.attack);
        }

        @Override
        public boolean isFood(ItemStack stack) {
            return stack.is(MobZ.KATHERINE_FOOD_TAG);
        }

        @Override
        protected boolean isTameItem(ItemStack stack) {
            return stack.is(MobZ.KATHERINE_TAME_TAG);
        }

        @Override
        protected boolean canEquipItemFromPlayer(ItemStack stack) {
            return stack.is(MobZ.KATHERINE_EQUIP_TAG);
        }
    }
}

