/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class EnderZombie
extends Zombie {
    public EnderZombie(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.ender_zombie.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, MobZ.configs.ender_zombie.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.ARMOR, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 10.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.SAYENDEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.ENDHURTEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.DEATHENDEVENT.get();
    }

    protected SoundEvent getStepSound() {
        return MobZSounds.STEPTANKEVENT.get();
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.ender_zombie.spawn && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    public boolean isBaby() {
        return false;
    }
}

