/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZArmors;
import net.mobz.init.MobZItems;
import net.mobz.init.MobZWeapons;

public class BossZombie
extends Zombie {
    public BossZombie(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 60;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.boss_zombie.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.21).add(Attributes.ATTACK_DAMAGE, MobZ.configs.boss_zombie.attack * MobZ.configs.damage_multiplier).add(Attributes.FOLLOW_RANGE, 36.0).add(Attributes.ARMOR, -4.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.1).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public boolean isUnderWaterConverting() {
        return false;
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)MobZWeapons.BOSS_SWORD.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)MobZItems.SHIELD.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)MobZArmors.BOSS_CHESTPLATE.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)MobZArmors.BOSS_BOOTS.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)MobZArmors.BOSS_LEGGINGS.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)MobZArmors.BOSS_HELMET.get()));
    }

    protected void dropCustomDeathLoot(ServerLevel serverWorld, DamageSource damageSource, boolean flag) {
    }

    public boolean removeWhenFarAway(double double_1) {
        return false;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.boss_zombie.spawn && this.level().isNight() && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }

    public boolean doHurtTarget(Entity victim) {
        boolean flag = super.doHurtTarget(victim);
        if (flag && victim instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)victim;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 120, 0, false, false));
        }
        return flag;
    }
}

