/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.entity.MobSpawnHelper;
import net.mobz.init.MobZSounds;

public class BossSkeleton
extends Skeleton {
    public BossSkeleton(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.boss_skeleton.life * MobZ.configs.life_multiplier).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ARMOR, 2.0);
    }

    protected SoundEvent getAmbientSound() {
        return MobZSounds.SKELASAYEVENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource_1) {
        return MobZSounds.SKELAHURTEVENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MobZSounds.SKELADEATHEVENT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            this.playSound(MobZSounds.SKELASTEPEVENT.get(), 0.15f, 1.0f);
        }
    }

    public boolean checkSpawnObstruction(LevelReader view) {
        return MobZ.configs.boss_skeleton.spawn && this.level().isNight() && MobSpawnHelper.checkSpawnObstruction((Entity)this, view);
    }
}

