/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.mobz.MobZ;
import net.mobz.init.MobZSounds;

public class Blackbear
extends Panda {
    public Blackbear(EntityType<? extends Panda> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMobzAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, MobZ.configs.black_bear.life).add(Attributes.MOVEMENT_SPEED, 0.17).add(Attributes.ATTACK_DAMAGE, MobZ.configs.black_bear.attack);
    }

    public void setAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(MobZ.configs.black_bear.life);
    }

    public boolean canHoldItem(ItemStack stack) {
        return false;
    }

    public boolean isSneezing() {
        return false;
    }

    public boolean isSitting() {
        return false;
    }

    public boolean isOnBack() {
        return false;
    }

    public boolean isEating() {
        return false;
    }

    public boolean isRolling() {
        return false;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isWorried() {
        return false;
    }

    public boolean isPlayful() {
        return false;
    }

    public boolean isWeak() {
        return false;
    }

    public boolean isAggressive() {
        return false;
    }

    public boolean doHurtTarget(Entity target) {
        this.playSound(MobZSounds.PBITEEVENT.get(), 1.0f, 1.0f);
        return super.doHurtTarget(target);
    }

    public boolean isScared() {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.POLAR_BEAR_AMBIENT;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.POLAR_BEAR_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.POLAR_BEAR_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.POLAR_BEAR_HURT;
    }
}

