/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.data;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.mobz.init.MobZArmors;
import net.mobz.init.MobZBlocks;
import net.mobz.init.MobZItems;
import net.mobz.init.MobZWeapons;

public class Recipes
extends RecipeProvider {
    public Recipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void buildRecipes(RecipeOutput recipeOutput) {
        Recipes.mobZ9BlockStorageRecipes(recipeOutput, RecipeCategory.MISC, (ItemLike)MobZItems.AMAT_INGOT.get(), RecipeCategory.MISC, (ItemLike)MobZBlocks.AMAT_BLOCK.get());
        Recipes.armorSet(recipeOutput, (ItemLike)MobZItems.AMAT_INGOT.get(), "has_amat_ingot", MobZArmors.AMAT_HELMET.get(), MobZArmors.AMAT_CHESTPLATE.get(), MobZArmors.AMAT_LEGGINGS.get(), MobZArmors.AMAT_BOOTS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZItems.LILITH_BOW.get())).define(Character.valueOf('A'), (ItemLike)MobZItems.AMAT_INGOT.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STRING).pattern(" AS").pattern("G S").pattern(" AS").unlockedBy("has_amat_ingot", Recipes.has((ItemLike)((ItemLike)MobZItems.AMAT_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MobZItems.AMAT_INGOT.get())).define(Character.valueOf('D'), (ItemLike)Blocks.NETHER_BRICKS).define(Character.valueOf('E'), (ItemLike)MobZItems.WITHER_POWDER.get()).define(Character.valueOf('F'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('O'), (ItemLike)Items.MAGMA_CREAM).pattern("FOF").pattern("EDE").pattern("FOF").unlockedBy("has_wither_powder", Recipes.has((ItemLike)((ItemLike)MobZItems.WITHER_POWDER.get()))).save(recipeOutput);
        Recipes.mobZ9BlockStorageRecipes(recipeOutput, RecipeCategory.MISC, (ItemLike)MobZItems.BOSS_INGOT.get(), RecipeCategory.MISC, (ItemLike)MobZBlocks.BOSS_BLOCK.get());
        Recipes.armorSet(recipeOutput, (ItemLike)MobZItems.BOSS_INGOT.get(), "has_boss_ingot", MobZArmors.BOSS_HELMET.get(), MobZArmors.BOSS_CHESTPLATE.get(), MobZArmors.BOSS_LEGGINGS.get(), MobZArmors.BOSS_BOOTS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZWeapons.BOSS_SWORD.get())).define(Character.valueOf('X'), (ItemLike)MobZItems.BOSS_INGOT.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern("X").pattern("X").pattern("#").unlockedBy("has_boss_ingot", Recipes.has((ItemLike)((ItemLike)MobZItems.BOSS_INGOT.get()))).save(recipeOutput);
        Recipes.mobZ9BlockStorageRecipes(recipeOutput, RecipeCategory.MISC, (ItemLike)MobZItems.HARDENEDMETAL_INGOT.get(), RecipeCategory.MISC, (ItemLike)MobZBlocks.HARDENED_METAL_BLOCK.get());
        Recipes.armorSet(recipeOutput, (ItemLike)MobZItems.HARDENEDMETAL_INGOT.get(), "has_hardened_metal_ingot", MobZArmors.LIFE_HELMET.get(), MobZArmors.LIFE_CHESTPLATE.get(), MobZArmors.LIFE_LEGGINGS.get(), MobZArmors.LIFE_BOOTS.get());
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_INGOT, (float)0.4f, (int)400).unlockedBy("has_hardened_metal_ingot", Recipes.has((ItemLike)((ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()))).save(recipeOutput, "mobz:iron_ingot_from_hardened_metal_ingot");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MobZItems.SACRIFICE_KNIFE.get())).define(Character.valueOf('X'), (ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern("X").pattern("#").unlockedBy("has_hardened_metal_ingot", Recipes.has((ItemLike)((ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZItems.SHIELD.get())).define(Character.valueOf('D'), (ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()).define(Character.valueOf('E'), ItemTags.PLANKS).define(Character.valueOf('F'), (ItemLike)MobZItems.BEAR_LEATHER.get()).pattern("DED").pattern("EFE").pattern("DED").unlockedBy("has_hardened_metal_ingot", Recipes.has((ItemLike)((ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()))).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.BEAR_LEATHER.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEATHER, (float)0.1f, (int)600).unlockedBy("has_bear_leather", Recipes.has((ItemLike)((ItemLike)MobZItems.BEAR_LEATHER.get()))).save(recipeOutput, "mobz:leather_from_bear_leather");
        Recipes.armorSet(recipeOutput, (ItemLike)MobZItems.BEAR_LEATHER.get(), "has_bear_leather", null, null, null, MobZArmors.SPEED_BOOTS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZArmors.SPEED2_BOOTS.get())).define(Character.valueOf('D'), (ItemLike)MobZArmors.SPEED_BOOTS.get()).define(Character.valueOf('E'), (ItemLike)Items.EMERALD).define(Character.valueOf('F'), (ItemLike)Items.EMERALD_BLOCK).pattern("EDE").pattern("FEF").unlockedBy("has_speed_boots", Recipes.has((ItemLike)((ItemLike)MobZArmors.SPEED_BOOTS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZWeapons.FROZEN_SWORD.get())).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('E'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)MobZItems.FROZEN_POWDER.get()).define(Character.valueOf('O'), (ItemLike)Items.SNOWBALL).pattern("ODO").pattern("FDF").pattern("OEO").unlockedBy("has_frozen_powder", Recipes.has((ItemLike)((ItemLike)MobZItems.FROZEN_POWDER.get()))).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.ROTTEN_FLESH.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEATHER, (float)0.1f, (int)240).unlockedBy("has_rotten_flesh", Recipes.has((ItemLike)((ItemLike)MobZItems.ROTTEN_FLESH.get()))).save(recipeOutput, "mobz:leather_from_rotten_flesh");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((TagKey)ItemTags.LOGS), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MobZBlocks.TOTEM_MIDDLE.get())).unlockedBy("has_log", Recipes.has((TagKey)ItemTags.LOGS)).save(recipeOutput);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WITHER_SKELETON_SKULL}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MobZItems.WITHER_POWDER.get()), (float)1.0f, (int)800).unlockedBy("has_wither_skull", Recipes.has((ItemLike)Items.WITHER_SKELETON_SKULL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MobZWeapons.WITHER_SWORD.get())).define(Character.valueOf('D'), (ItemLike)Items.IRON_SWORD).define(Character.valueOf('E'), (ItemLike)MobZItems.WITHER_POWDER.get()).define(Character.valueOf('F'), (ItemLike)Items.END_CRYSTAL).define(Character.valueOf('O'), (ItemLike)Items.DRAGON_BREATH).pattern("EFE").pattern("ODO").pattern("EFE").unlockedBy("has_wither_powder", Recipes.has((ItemLike)((ItemLike)MobZItems.WITHER_POWDER.get()))).save(recipeOutput);
    }

    public static void mobZ9BlockStorageRecipes(RecipeOutput pRecipeOutput, RecipeCategory pUnpackedCategory, ItemLike pUnpacked, RecipeCategory pPackedCategory, ItemLike pPacked) {
        ResourceLocation unpackedName = BuiltInRegistries.ITEM.getKey((Object)pUnpacked.asItem());
        ResourceLocation packedName = BuiltInRegistries.ITEM.getKey((Object)pPacked.asItem());
        Recipes.nineBlockStorageRecipes((RecipeOutput)pRecipeOutput, (RecipeCategory)pUnpackedCategory, (ItemLike)pUnpacked, (RecipeCategory)pPackedCategory, (ItemLike)pPacked, (String)(packedName.toString() + "_from_unpacked"), null, (String)(unpackedName.toString() + "_from_packed"), null);
    }

    public static void armorSet(RecipeOutput recipeOutput, ItemLike ingredient, String unlockedByName, ArmorItem helmet, ArmorItem chestplate, ArmorItem leggings, @Nullable ArmorItem boots) {
        if (helmet != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('X'), ingredient).pattern("XXX").pattern("X X").unlockedBy(unlockedByName, Recipes.has((ItemLike)ingredient)).save(recipeOutput);
        }
        if (chestplate != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('X'), ingredient).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy(unlockedByName, Recipes.has((ItemLike)ingredient)).save(recipeOutput);
        }
        if (leggings != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('X'), ingredient).pattern("XXX").pattern("X X").pattern("X X").unlockedBy(unlockedByName, Recipes.has((ItemLike)ingredient)).save(recipeOutput);
        }
        if (boots != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('X'), ingredient).pattern("X X").pattern("X X").unlockedBy(unlockedByName, Recipes.has((ItemLike)ingredient)).save(recipeOutput);
        }
    }
}

