/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.data;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.mobz.data.RewardLoot;
import net.mobz.init.MobZEntities;

public class MobAdvancements
implements AdvancementSubProvider {
    public static final ResourceLocation BACKGROUND = ResourceLocation.tryBuild((String)"minecraft", (String)"textures/gui/advancements/backgrounds/adventure.png");

    public static Item icon(String name) {
        ResourceLocation resLoc = ResourceLocation.tryBuild((String)"mobz", (String)name);
        Item item = (Item)BuiltInRegistries.ITEM.get(resLoc);
        return item;
    }

    public static AdvancementHolder advancement(Consumer<AdvancementHolder> writer, EntityType<?> entityType, @Nullable String iconName, @Nullable AdvancementHolder parent, AdvancementType type, boolean showToast, boolean announceChat, boolean hidden, @Nullable AdvancementRewards.Builder rewardBuilder, BiConsumer<String, Advancement.Builder> criterionAdder) {
        String name = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath();
        if (iconName == null) {
            iconName = "head_" + name;
        }
        Advancement.Builder builder = Advancement.Builder.advancement().display((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.tryBuild((String)"mobz", (String)iconName)), (Component)Component.translatable((String)("entity.mobz." + name)), (Component)Component.translatable((String)("mobz.advancements." + name + ".description")), null, type, showToast, announceChat, hidden);
        criterionAdder.accept(name, builder);
        if (parent != null) {
            builder.parent(parent);
        }
        if (rewardBuilder != null) {
            builder.rewards(rewardBuilder);
        }
        return builder.save(writer, "mobz:mob/" + name);
    }

    public static AdvancementHolder killByPlayer(Consumer<AdvancementHolder> writer, EntityType<?> entityType, @Nullable String iconName, @Nullable AdvancementHolder parent, AdvancementType type, boolean showToast, boolean announceChat, boolean hidden, @Nullable AdvancementRewards.Builder rewardBuilder) {
        return MobAdvancements.advancement(writer, entityType, iconName, parent, type, showToast, announceChat, hidden, rewardBuilder, (name, builder) -> builder.addCriterion("player_killed_" + name, KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType))));
    }

    public static AdvancementHolder hurtByPlayer(Consumer<AdvancementHolder> writer, EntityType<?> entityType, @Nullable String iconName, @Nullable AdvancementHolder parent, AdvancementType type, boolean showToast, boolean announceChat, boolean hidden, @Nullable AdvancementRewards.Builder rewardBuilder) {
        return MobAdvancements.advancement(writer, entityType, iconName, parent, type, showToast, announceChat, hidden, rewardBuilder, (name, builder) -> builder.addCriterion("player_hurt_" + name, PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity(Optional.of(EntityPredicate.Builder.entity().of(entityType).build()))));
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> writer) {
        AdvancementHolder started = Advancement.Builder.advancement().display((ItemLike)MobAdvancements.icon("head_start"), (Component)Component.translatable((String)"mobz.advancements.start.title"), (Component)Component.translatable((String)"mobz.advancements.start.description"), BACKGROUND, AdvancementType.TASK, true, false, false).addCriterion("kill_anything", KilledTrigger.TriggerInstance.playerKilledEntity()).addCriterion("hurt_anything", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity()).sendsTelemetryEvent().save(writer, "mobz:mob/started");
        AdvancementHolder frost_creeper = MobAdvancements.killByPlayer(writer, MobZEntities.FROST_CREEPER.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder baby_ravager = MobAdvancements.killByPlayer(writer, MobZEntities.BABY_RAVAGER.get(), null, started, AdvancementType.GOAL, true, false, true, null);
        AdvancementHolder stone_golem = MobAdvancements.killByPlayer(writer, MobZEntities.STONEGOLEM.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder frost_blaze = MobAdvancements.killByPlayer(writer, MobZEntities.FROST_BLAZE.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder ender_zombie = MobAdvancements.killByPlayer(writer, MobZEntities.ENDER_ZOMBIE.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder purple_spider = MobAdvancements.killByPlayer(writer, MobZEntities.PURPLE_SPIDER.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder fast_zombie = MobAdvancements.killByPlayer(writer, MobZEntities.FAST_ZOMBIE.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder spider_mage = MobAdvancements.killByPlayer(writer, MobZEntities.SPIDER_MAGE.get(), "head_zombie_mage", started, AdvancementType.GOAL, true, false, true, null);
        AdvancementHolder lost_skeleton = MobAdvancements.killByPlayer(writer, MobZEntities.LOST_SKELETON.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder warrior = MobAdvancements.killByPlayer(writer, MobZEntities.WARRIOR.get(), null, started, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder cookie_creeper = MobAdvancements.killByPlayer(writer, MobZEntities.COOKIE_CREEPER.get(), null, frost_creeper, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder iron_steve = MobAdvancements.killByPlayer(writer, MobZEntities.IRON_STEVE.get(), null, warrior, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder blue_spider = MobAdvancements.killByPlayer(writer, MobZEntities.BLUE_SPIDER.get(), null, purple_spider, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder bowman = MobAdvancements.killByPlayer(writer, MobZEntities.BOWMAN.get(), null, warrior, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder tank_zombie = MobAdvancements.killByPlayer(writer, MobZEntities.TANK_ZOMBIE.get(), "head_fast_zombie", fast_zombie, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder william = MobAdvancements.killByPlayer(writer, MobZEntities.WILLIAM.get(), null, baby_ravager, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder ender = MobAdvancements.killByPlayer(writer, MobZEntities.ENDER.get(), null, ender_zombie, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder zombie_mage = MobAdvancements.killByPlayer(writer, MobZEntities.ZOMBIE_MAGE.get(), null, spider_mage, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder lava_golem = MobAdvancements.killByPlayer(writer, MobZEntities.LAVAGOLEM.get(), null, stone_golem, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder overgrown_skeleton = MobAdvancements.killByPlayer(writer, MobZEntities.OVERGROWN_SKELETON.get(), null, lost_skeleton, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder wither_blaze = MobAdvancements.killByPlayer(writer, MobZEntities.WITHER_BLAZE.get(), null, frost_blaze, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder ice_golem = MobAdvancements.killByPlayer(writer, MobZEntities.ICEGOLEM.get(), null, lava_golem, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder nether_skeleton = MobAdvancements.killByPlayer(writer, MobZEntities.NETHER_SKELETON.get(), null, overgrown_skeleton, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder pillager_boss = MobAdvancements.killByPlayer(writer, MobZEntities.PILLAGER_BOSS.get(), null, zombie_mage, AdvancementType.CHALLENGE, true, false, true, AdvancementRewards.Builder.experience((int)20).addLootTable(RewardLoot.BIGBOSS));
        AdvancementHolder dwarf = MobAdvancements.killByPlayer(writer, MobZEntities.DWARF.get(), null, iron_steve, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder andriu = MobAdvancements.killByPlayer(writer, MobZEntities.ANDRIU.get(), null, william, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder armored_zombie = MobAdvancements.killByPlayer(writer, MobZEntities.ARMORED_ZOMBIE.get(), "head_fast_zombie", tank_zombie, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder archer = MobAdvancements.killByPlayer(writer, MobZEntities.ARCHER.get(), null, bowman, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder soul_creeper = MobAdvancements.killByPlayer(writer, MobZEntities.SOUL_CREEPER.get(), null, cookie_creeper, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder katherine = MobAdvancements.hurtByPlayer(writer, MobZEntities.KATHERINE.get(), null, iron_steve, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder fiora = MobAdvancements.hurtByPlayer(writer, MobZEntities.FIORA.get(), null, katherine, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder charles = MobAdvancements.killByPlayer(writer, MobZEntities.CHARLES.get(), null, andriu, AdvancementType.CHALLENGE, true, true, false, AdvancementRewards.Builder.experience((int)40).addLootTable(RewardLoot.BIGBOSS));
        AdvancementHolder templar = MobAdvancements.killByPlayer(writer, MobZEntities.TEMPLAR.get(), null, dwarf, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder boss_skeleton = MobAdvancements.killByPlayer(writer, MobZEntities.BOSS_SKELETON.get(), null, nether_skeleton, AdvancementType.CHALLENGE, true, false, false, null);
        AdvancementHolder boss_zombie = MobAdvancements.killByPlayer(writer, MobZEntities.BOSS_ZOMBIE.get(), null, armored_zombie, AdvancementType.CHALLENGE, true, false, true, AdvancementRewards.Builder.experience((int)50).addLootTable(RewardLoot.BOSS_ZOMBIE));
        AdvancementHolder ender_knight = MobAdvancements.killByPlayer(writer, MobZEntities.ENDER_KNIGHT.get(), null, templar, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder metal_golem = MobAdvancements.killByPlayer(writer, MobZEntities.METALGOLEM.get(), null, fiora, AdvancementType.GOAL, true, false, true, null);
        AdvancementHolder lord_of_darkness = MobAdvancements.killByPlayer(writer, MobZEntities.LORD_OF_DARKNESS.get(), null, ender_knight, AdvancementType.GOAL, true, false, false, null);
        AdvancementHolder withender = MobAdvancements.killByPlayer(writer, MobZEntities.WITHENDER.get(), null, lord_of_darkness, AdvancementType.CHALLENGE, true, false, true, null);
    }
}

