/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.data;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.mobz.init.MobZBlocks;

public class BlockLoot
extends BlockLootSubProvider {
    private final List<Block> blocks = new LinkedList<Block>();

    protected BlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void add(Block pBlock, LootTable.Builder pBuilder) {
        super.add(pBlock, pBuilder);
        this.blocks.add(pBlock);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        this.generate();
        HashSet<ResourceKey> processed = new HashSet<ResourceKey>();
        for (Block block : this.blocks) {
            ResourceKey resourceKey;
            if (!block.isEnabled(this.enabledFeatures) || (resourceKey = block.getLootTable()) == BuiltInLootTables.EMPTY || !processed.add(resourceKey)) continue;
            LootTable.Builder builder = (LootTable.Builder)this.map.remove(resourceKey);
            if (builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourceKey.location(), BuiltInRegistries.BLOCK.getKey((Object)block)));
            }
            biConsumer.accept((ResourceKey<LootTable>)resourceKey, builder);
        }
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
        }
    }

    public void generate() {
        this.dropSelf(MobZBlocks.AMAT_BLOCK.get());
        this.dropSelf(MobZBlocks.BOSS_BLOCK.get());
        this.dropSelf(MobZBlocks.BOSS_TROPHY.get());
        this.dropSelf(MobZBlocks.ENDER_HEADER.get());
        this.dropSelf(MobZBlocks.HARDENED_METAL_BLOCK.get());
        this.dropSelf(MobZBlocks.TOTEM_BASE.get());
        this.dropSelf(MobZBlocks.TOTEM_MIDDLE.get());
        this.dropSelf(MobZBlocks.TOTEM_TOP.get());
    }
}

