/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.mobz.MathUtils;
import net.mobz.entity.ToadEntity;

public class ToadEntityModel
extends EntityModel<ToadEntity> {
    private static final Set<Direction> ALL_VISIBLE = EnumSet.allOf(Direction.class);
    public static final Random random = new Random();
    private final float bodyScale;
    private final ModelPart body;
    private final ModelPart backlege;
    private final ModelPart backlegw;
    private final ModelPart eyeballw;
    private final ModelPart eyeballe;
    private final ModelPart lips;
    private final ModelPart lipBottom;
    private final ModelPart lipTop;
    private final ModelPart frontlegw;
    private final ModelPart frontlege;
    private float tongue_xRot;
    private float tongue_yRot;
    private float tongueDistance;
    private float targetTongueDistance;
    private float eyeHeight;
    public static final ModelLayerLocation modelResLoc = new ModelLayerLocation(ResourceLocation.tryBuild((String)"mobz", (String)"toad_model"), "main");

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -2.0f, 8.0f, 8.0f, 8.0f).texOffs(10, 24).addBox(1.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f).texOffs(0, 24).addBox(-3.0f, -10.0f, -1.0f, 2.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)-0.2727f));
        body.addOrReplaceChild("backlege", CubeListBuilder.create().texOffs(8, 16).addBox(-2.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f).texOffs(12, 16).addBox(-2.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.offset((float)-4.0f, (float)-3.0f, (float)5.0f));
        body.addOrReplaceChild("backlegw", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -1.0f, -2.0f, 2.0f, 4.0f, 4.0f).texOffs(24, 16).addBox(0.0f, 2.0f, -4.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)4.0f, (float)-3.0f, (float)5.0f));
        body.addOrReplaceChild("eyeballw", CubeListBuilder.create().texOffs(18, 28).addBox(0.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offset((float)2.5f, (float)-9.5f, (float)0.5f));
        body.addOrReplaceChild("eyeballe", CubeListBuilder.create().texOffs(24, 3).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.offset((float)-2.5f, (float)-9.5f, (float)0.5f));
        PartDefinition lips = body.addOrReplaceChild("lips", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-2.0f));
        lips.addOrReplaceChild("lip_bottom", CubeListBuilder.create().texOffs(20, 18).addBox(-3.0f, 1.0f, -1.0f, 6.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        lips.addOrReplaceChild("lip_top", CubeListBuilder.create().texOffs(20, 16).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontlegw = body.addOrReplaceChild("frontlegw", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-5.0f, (float)-1.0f));
        frontlegw.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(22, 22).addBox(0.0f, 0.684f, -1.3794f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition frontlege = body.addOrReplaceChild("frontlege", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-5.0f, (float)-1.0f));
        frontlege.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, 0.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ToadEntityModel(ModelPart modelPart, float bodyScale) {
        this.bodyScale = bodyScale;
        this.body = modelPart.getChild("body");
        this.backlege = this.body.getChild("backlege");
        this.backlegw = this.body.getChild("backlegw");
        this.eyeballw = this.body.getChild("eyeballw");
        this.eyeballe = this.body.getChild("eyeballe");
        this.lips = this.body.getChild("lips");
        this.lipBottom = this.lips.getChild("lip_bottom");
        this.lipTop = this.lips.getChild("lip_top");
        this.frontlegw = this.body.getChild("frontlegw");
        this.frontlege = this.body.getChild("frontlege");
    }

    public void setupAnim(ToadEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        float legAmount = 1.4f;
        this.frontlege.xRot = Mth.cos((float)(limbAngle * 1.0f + pi)) * 1.4f * limbDistance;
        this.backlege.xRot = Mth.cos((float)(limbAngle * 1.0f)) * legAmount * limbDistance;
        this.frontlegw.xRot = Mth.cos((float)(limbAngle * 1.0f)) * 1.4f * limbDistance;
        this.backlegw.xRot = Mth.cos((float)(limbAngle * 1.0f + pi)) * legAmount * limbDistance;
        if (!entity.onGround()) {
            this.backlegw.xRot = 2.0f;
            this.backlege.xRot = 2.0f;
        }
        entity.mouthDistance = entity.hasTongueEntity() ? MathUtils.approachValue(entity.mouthDistance, 1.0f, 0.5f) : MathUtils.approachValue(entity.mouthDistance, 0.0f, 0.1f);
        this.lipTop.y = -entity.mouthDistance;
        this.lipBottom.y = entity.mouthDistance;
        this.tongue_xRot = headPitch * 0.0175f;
        this.tongue_yRot = headYaw * 0.0175f;
        this.tongueDistance = entity.tongueDistance;
        this.targetTongueDistance = entity.targetTongueDistance;
        this.eyeHeight = entity.getEyeHeight();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int overlayCoord, int packedColor) {
        this.body.render(poseStack, vertexConsumer, packedLight, overlayCoord, packedColor);
        if (this.tongueDistance <= 0.01f) {
            return;
        }
        poseStack.pushPose();
        this.body.translateAndRotate(poseStack);
        this.renderTongue(poseStack, vertexConsumer, packedLight, overlayCoord, packedColor);
        poseStack.popPose();
    }

    public void renderTongue(PoseStack matrices, VertexConsumer vertexConsumer, int packedLight, int overlayCoord, int packedColor) {
        matrices.pushPose();
        float mouthHeightRelative = 0.1875f;
        float mouthHorizontalOffsetRelative = 0.125f;
        float tongueDistance = this.targetTongueDistance;
        float mouthHeight = mouthHeightRelative * this.bodyScale;
        float mouthHorizontalOffset = mouthHorizontalOffsetRelative * this.bodyScale;
        float mouthVerticalOffset = this.eyeHeight - mouthHeight;
        float mouthEyeDistanceSqr = mouthVerticalOffset * mouthVerticalOffset + mouthHorizontalOffset * mouthHorizontalOffset;
        float mouthEyeDistance = Mth.sqrt((float)mouthEyeDistanceSqr);
        float angleMouthEye = (float)Mth.atan2((double)mouthHorizontalOffset, (double)mouthVerticalOffset);
        float cosEM_ET = Mth.sin((float)(angleMouthEye + this.tongue_xRot));
        float lenSqr = mouthEyeDistanceSqr + tongueDistance * tongueDistance - 2.0f * mouthEyeDistance * tongueDistance * cosEM_ET;
        float len = Mth.sqrt((float)lenSqr);
        float cosME_MT = (mouthEyeDistanceSqr + lenSqr - tongueDistance * tongueDistance) / (2.0f * mouthEyeDistance * len);
        float xRot = (float)(Math.acos(cosME_MT) - 1.5707963705062866 - (double)angleMouthEye);
        len *= this.tongueDistance / this.targetTongueDistance;
        matrices.translate(0.0f, -mouthHeightRelative, -mouthHorizontalOffsetRelative);
        if (xRot != 0.0f) {
            matrices.mulPose(Axis.XP.rotation(xRot));
        }
        if (this.tongue_yRot != 0.0f) {
            matrices.mulPose(Axis.YP.rotation(this.tongue_yRot));
        }
        matrices.scale(1.0f, 1.0f, len / this.bodyScale * 16.0f);
        ModelPart.Cube cuboid = new ModelPart.Cube(16, 0, -1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_VISIBLE);
        cuboid.compile(matrices.last(), vertexConsumer, packedLight, overlayCoord, packedColor);
        matrices.popPose();
    }
}

