/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.mobz.entity.TadpoleEntity;

public class TadpoleEntityModel
extends ListModel<TadpoleEntity> {
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart finw;
    private final ModelPart fine;
    public static final ModelLayerLocation modelResLoc = new ModelLayerLocation(ResourceLocation.tryBuild((String)"mobz", (String)"tadpole_model"), "main");

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -1.0f, 3.0f, 2.0f, 3.0f).texOffs(0, 11).addBox(-4.0f, -2.0f, -1.0f, 1.0f, 1.0f, 1.0f).texOffs(8, 9).addBox(-2.0f, -2.0f, -1.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)2.0f, (float)23.0f, (float)-3.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.6f, -1.0f, 0.0f, 3.0f, 6.0f).texOffs(4, 9).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f), PartPose.offset((float)-2.5f, (float)0.0f, (float)2.0f));
        body.addOrReplaceChild("finw", CubeListBuilder.create().texOffs(0, 9).addBox(0.0f, 0.0f, -1.0f, 2.0f, 0.01f, 2.0f), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition fine = body.addOrReplaceChild("fine", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        fine.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(7, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 0.01f, 2.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.0436f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public TadpoleEntityModel(ModelPart modelPart) {
        this.body = modelPart.getChild("body");
        this.tail = this.body.getChild("tail");
        this.finw = this.body.getChild("finw");
        this.fine = this.body.getChild("fine");
    }

    public void setupAnim(TadpoleEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin((float)(0.6f * animationProgress));
        this.finw.xRot = f * 0.1f * Mth.sin((float)(0.8f * animationProgress));
        this.fine.xRot = f * 0.1f * Mth.sin((float)(0.8f * animationProgress));
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }
}

