/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.mobz.client.renderer.model.TadpoleEntityModel;
import net.mobz.entity.TadpoleEntity;

public class TadpoleRender
extends MobRenderer<TadpoleEntity, TadpoleEntityModel> {
    private static final ResourceLocation TEXTURE = ResourceLocation.tryBuild((String)"mobz", (String)"textures/entity/tadpole.png");

    public TadpoleRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TadpoleEntityModel(context.bakeLayer(TadpoleEntityModel.modelResLoc)), 0.15f);
    }

    protected void setupRotations(TadpoleEntity tadpole, PoseStack matrixStack, float f, float g, float h, float i) {
        super.setupRotations((LivingEntity)tadpole, matrixStack, f, g, h, i);
        float yRotate = 4.3f * Mth.sin((float)(0.6f * f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(yRotate));
        if (!tadpole.isInWater()) {
            matrixStack.translate((double)0.1f, (double)0.1f, (double)-0.1f);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }

    public ResourceLocation getTextureLocation(TadpoleEntity entity) {
        return TEXTURE;
    }
}

