/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.mobz.client.renderer.entity.EasyGolemRenderer;

public class MetalGolemRenderer
extends EasyGolemRenderer {
    public MetalGolemRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context, texture, false);
        this.addLayer(new MetalGolemCrack((RenderLayerParent<IronGolem, IronGolemModel<IronGolem>>)this));
    }

    protected void scale(IronGolem golem, PoseStack matrixStack, float f) {
        matrixStack.scale(1.15f, 1.15f, 1.15f);
    }

    public static class MetalGolemCrack
    extends RenderLayer<IronGolem, IronGolemModel<IronGolem>> {
        private static final Map<Crackiness.Level, ResourceLocation> DAMAGE_TO_TEXTURE = ImmutableMap.of((Object)Crackiness.Level.LOW, (Object)ResourceLocation.tryBuild((String)"mobz", (String)"textures/entity/metal_golem_crackiness_low.png"), (Object)Crackiness.Level.MEDIUM, (Object)ResourceLocation.tryBuild((String)"mobz", (String)"textures/entity/metal_golem_crackiness_medium.png"), (Object)Crackiness.Level.HIGH, (Object)ResourceLocation.tryBuild((String)"mobz", (String)"textures/entity/metal_golem_crackiness_high.png"));

        public MetalGolemCrack(RenderLayerParent<IronGolem, IronGolemModel<IronGolem>> featureRendererContext) {
            super(featureRendererContext);
        }

        public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, IronGolem ironGolemEntity, float f, float g, float h, float j, float k, float l) {
            Crackiness.Level crack;
            if (!ironGolemEntity.isInvisible() && (crack = ironGolemEntity.getCrackiness()) != Crackiness.Level.NONE) {
                ResourceLocation identifier = DAMAGE_TO_TEXTURE.get(crack);
                MetalGolemCrack.renderColoredCutoutModel((EntityModel)this.getParentModel(), (ResourceLocation)identifier, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumerProvider, (int)i, (LivingEntity)ironGolemEntity, (int)-1);
            }
        }
    }
}

