/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;

public class HoneySlimeRenderer
extends MobRenderer<Slime, SlimeModel<Slime>> {
    private final ResourceLocation texture;

    public HoneySlimeRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(ModelLayers.SLIME)), 0.25f);
        this.addLayer((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, context.getModelSet()));
        this.texture = texture;
    }

    public void render(Slime slimeEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.shadowRadius = 0.25f * (float)slimeEntity.getSize();
        super.render((LivingEntity)slimeEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    protected void scale(Slime slimeEntity, PoseStack matrixStack, float f) {
        matrixStack.scale(0.999f, 0.999f, 0.999f);
        matrixStack.translate(0.0, (double)0.001f, 0.0);
        float h = slimeEntity.getSize();
        float i = Mth.lerp((float)f, (float)slimeEntity.oSquish, (float)slimeEntity.squish) / (h * 0.5f + 1.0f);
        float j = 1.0f / (i + 1.0f);
        matrixStack.scale(j * h, 1.0f / j * h, j * h);
    }

    public ResourceLocation getTextureLocation(Slime slimeEntity) {
        return this.texture;
    }
}

