/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CarriedBlockLayer;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EnderRenderer
extends MobRenderer<EnderMan, EndermanModel<EnderMan>> {
    private final ResourceLocation texture;
    private final Random random = new Random();

    public EnderRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context, (EntityModel)new EndermanModel(context.bakeLayer(ModelLayers.ENDERMAN)), 0.5f);
        this.addLayer((RenderLayer)new CarriedBlockLayer((RenderLayerParent)this, context.getBlockRenderDispatcher()));
        this.texture = texture;
        String eyePath = texture.getPath().replace(".png", "_eyes.png");
        ResourceLocation eyeTexture = ResourceLocation.tryBuild((String)texture.getNamespace(), (String)eyePath);
        this.addLayer((RenderLayer)new EnderEyes(this, eyeTexture));
    }

    public void render(EnderMan endermanEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        BlockState blockState = endermanEntity.getCarriedBlock();
        EndermanModel endermanEntityModel = (EndermanModel)this.getModel();
        endermanEntityModel.carrying = blockState != null;
        endermanEntityModel.creepy = endermanEntity.isCreepy();
        super.render((LivingEntity)endermanEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public Vec3 getRenderOffset(EnderMan endermanEntity, float f) {
        if (endermanEntity.isCreepy()) {
            return new Vec3(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02);
        }
        return super.getRenderOffset((Entity)endermanEntity, f);
    }

    public ResourceLocation getTextureLocation(EnderMan endermanEntity) {
        return this.texture;
    }

    public static class EnderEyes<T extends LivingEntity>
    extends EyesLayer<T, EndermanModel<T>> {
        private final RenderType texture;

        public EnderEyes(RenderLayerParent<T, EndermanModel<T>> context, ResourceLocation eyeTexture) {
            super(context);
            this.texture = RenderType.eyes((ResourceLocation)eyeTexture);
        }

        public RenderType renderType() {
            return this.texture;
        }
    }
}

