/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.IronGolemCrackinessLayer;
import net.minecraft.client.renderer.entity.layers.IronGolemFlowerLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;

public class EasyGolemRenderer
extends MobRenderer<IronGolem, IronGolemModel<IronGolem>> {
    private final ResourceLocation texture;

    public EasyGolemRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        this(context, texture, true);
    }

    protected EasyGolemRenderer(EntityRendererProvider.Context context, ResourceLocation texture, boolean useDefaultCrack) {
        super(context, (EntityModel)new IronGolemModel(context.bakeLayer(ModelLayers.IRON_GOLEM)), 0.7f);
        if (useDefaultCrack) {
            this.addLayer((RenderLayer)new IronGolemCrackinessLayer((RenderLayerParent)this));
        }
        this.addLayer((RenderLayer)new IronGolemFlowerLayer((RenderLayerParent)this, context.getBlockRenderDispatcher()));
        this.texture = texture;
    }

    public ResourceLocation getTextureLocation(IronGolem stone) {
        return this.texture;
    }

    protected void setupRotations(IronGolem ironGolemEntity, PoseStack matrixStack, float f, float g, float h, float i) {
        super.setupRotations((LivingEntity)ironGolemEntity, matrixStack, f, g, h, i);
        if ((double)ironGolemEntity.walkAnimation.speed() >= 0.01) {
            float j = ironGolemEntity.walkAnimation.position() - ironGolemEntity.walkAnimation.speed() * (1.0f - h) + 6.0f;
            float k = (Math.abs(j % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrixStack.mulPose(Axis.ZP.rotationDegrees(6.5f * k));
        }
    }
}

