/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Creeper;

public class EasyCreeperRenderer
extends MobRenderer<Creeper, CreeperModel<Creeper>> {
    private final ResourceLocation texture;

    public EasyCreeperRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context, (EntityModel)new CreeperModel(context.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new CreeperPowerLayer((RenderLayerParent)this, context.getModelSet()));
        this.texture = texture;
    }

    protected void scale(Creeper creeperEntity, PoseStack matrixStack, float f) {
        float g = creeperEntity.getSwelling(f);
        float h = 1.0f + Mth.sin((float)(g * 100.0f)) * g * 0.01f;
        g = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
        g *= g;
        g *= g;
        float i = (1.0f + g * 0.4f) * h;
        float j = (1.0f + g * 0.1f) / h;
        matrixStack.scale(i, j, i);
    }

    protected float getBob(Creeper creeperEntity, float f) {
        float g = creeperEntity.getSwelling(f);
        return (int)(g * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)g, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(Creeper creeperEntity) {
        return this.texture;
    }
}

