/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.client.renderer.entity;

import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Chicken;

public class EasyChickenRenderer<T extends Chicken>
extends MobRenderer<T, ChickenModel<T>> {
    private final ResourceLocation texture;

    public EasyChickenRenderer(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context, (EntityModel)new ChickenModel(context.bakeLayer(ModelLayers.CHICKEN)), 0.3f);
        this.texture = texture;
    }

    public ResourceLocation getTextureLocation(T chickenEntity) {
        return this.texture;
    }

    protected float getBob(Chicken chickenEntity, float f) {
        float g = Mth.lerp((float)f, (float)chickenEntity.oFlap, (float)chickenEntity.flap);
        float h = Mth.lerp((float)f, (float)chickenEntity.oFlapSpeed, (float)chickenEntity.flapSpeed);
        return (Mth.sin((float)g) + 1.0f) * h;
    }
}

