/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.mobz.entity.PillagerBoss;
import net.mobz.init.MobZEntities;

public class TotemBase
extends Block {
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)TotemBase.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{TotemBase.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), TotemBase.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), TotemBase.box((double)3.0, (double)5.0, (double)4.0, (double)4.0, (double)8.0, (double)5.0), TotemBase.box((double)3.0, (double)5.0, (double)11.0, (double)4.0, (double)8.0, (double)12.0), TotemBase.box((double)2.0, (double)6.0, (double)4.0, (double)3.0, (double)9.0, (double)5.0), TotemBase.box((double)1.0, (double)8.0, (double)4.0, (double)2.0, (double)11.0, (double)5.0), TotemBase.box((double)2.0, (double)6.0, (double)11.0, (double)3.0, (double)9.0, (double)12.0), TotemBase.box((double)1.0, (double)8.0, (double)11.0, (double)2.0, (double)11.0, (double)12.0), TotemBase.box((double)4.0, (double)5.0, (double)3.0, (double)5.0, (double)8.0, (double)4.0), TotemBase.box((double)4.0, (double)6.0, (double)2.0, (double)5.0, (double)9.0, (double)3.0), TotemBase.box((double)4.0, (double)8.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0), TotemBase.box((double)11.0, (double)5.0, (double)3.0, (double)12.0, (double)8.0, (double)4.0), TotemBase.box((double)11.0, (double)6.0, (double)2.0, (double)12.0, (double)9.0, (double)3.0), TotemBase.box((double)11.0, (double)8.0, (double)1.0, (double)12.0, (double)11.0, (double)2.0), TotemBase.box((double)11.0, (double)5.0, (double)12.0, (double)12.0, (double)8.0, (double)13.0), TotemBase.box((double)11.0, (double)6.0, (double)13.0, (double)12.0, (double)9.0, (double)14.0), TotemBase.box((double)11.0, (double)8.0, (double)14.0, (double)12.0, (double)11.0, (double)15.0), TotemBase.box((double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)8.0, (double)13.0), TotemBase.box((double)4.0, (double)6.0, (double)13.0, (double)5.0, (double)9.0, (double)14.0), TotemBase.box((double)4.0, (double)8.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0), TotemBase.box((double)12.0, (double)5.0, (double)11.0, (double)13.0, (double)8.0, (double)12.0), TotemBase.box((double)13.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0, (double)12.0), TotemBase.box((double)14.0, (double)8.0, (double)11.0, (double)15.0, (double)11.0, (double)12.0), TotemBase.box((double)12.0, (double)5.0, (double)4.0, (double)13.0, (double)8.0, (double)5.0), TotemBase.box((double)13.0, (double)6.0, (double)4.0, (double)14.0, (double)9.0, (double)5.0), TotemBase.box((double)14.0, (double)8.0, (double)4.0, (double)15.0, (double)11.0, (double)5.0), TotemBase.box((double)4.0, (double)14.0, (double)3.0, (double)5.0, (double)16.0, (double)4.0), TotemBase.box((double)11.0, (double)14.0, (double)3.0, (double)12.0, (double)16.0, (double)4.0), TotemBase.box((double)12.0, (double)14.0, (double)4.0, (double)13.0, (double)16.0, (double)5.0), TotemBase.box((double)12.0, (double)14.0, (double)11.0, (double)13.0, (double)16.0, (double)12.0), TotemBase.box((double)11.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0, (double)13.0), TotemBase.box((double)4.0, (double)14.0, (double)12.0, (double)5.0, (double)16.0, (double)13.0), TotemBase.box((double)3.0, (double)14.0, (double)11.0, (double)4.0, (double)16.0, (double)12.0), TotemBase.box((double)3.0, (double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)5.0), TotemBase.box((double)3.0, (double)15.0, (double)3.0, (double)4.0, (double)16.0, (double)4.0), TotemBase.box((double)12.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0), TotemBase.box((double)12.0, (double)15.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0), TotemBase.box((double)3.0, (double)15.0, (double)12.0, (double)4.0, (double)16.0, (double)13.0)});

    public TotemBase(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENABLED});
    }

    public void trigger(Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
        world.scheduleTick(pos, (Block)this, 100, TickPriority.HIGH);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)ENABLED)).booleanValue()) {
            world.removeBlock(pos, false);
            world.removeBlock(pos.above(), false);
            world.removeBlock(pos.above().above(), false);
            PillagerBoss pillager = (PillagerBoss)MobZEntities.PILLAGER_BOSS.get().create((Level)world);
            BlockPos spawnPos = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
            pillager.moveTo(spawnPos, 0.0f, 0.0f);
            world.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.HOSTILE, 1.0f, 1.0f);
            world.addFreshEntity((Entity)pillager);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)ENABLED)).booleanValue()) {
            for (int i = 0; i < 10; ++i) {
                double d = (double)pos.getX() + (double)rand.nextFloat();
                double e = (double)pos.getY() + (double)rand.nextFloat();
                double f = (double)pos.getZ() + (double)rand.nextFloat();
                double o = (double)pos.getY() + ((double)rand.nextFloat() + 1.0);
                double r = (double)pos.getY() - (double)rand.nextFloat();
                world.addParticle((ParticleOptions)ParticleTypes.ASH, d, e, f, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, o, f, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, r, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"block.mobz.totem_base.tooltip"));
    }
}

