/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.block;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.mobz.entity.MetalGolem;
import net.mobz.init.MobZEntities;

public class HardenedMetalBlock
extends Block {
    @Nullable
    private BlockPattern golemPattern;
    private static final Predicate<BlockState> IS_PUMPKIN = state -> state != null && (state.is(Blocks.CARVED_PUMPKIN) || state.is(Blocks.JACK_O_LANTERN));

    public HardenedMetalBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    private BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState(IS_PUMPKIN)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)this))).where('~', BlockInWorld.hasState(blockState -> blockState.isAir())).build();
        }
        return this.golemPattern;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        BlockPattern.BlockPatternMatch blockpattern$patternhelper = this.getGolemPattern().find((LevelReader)world, pos);
        if (blockpattern$patternhelper != null) {
            for (int j = 0; j < this.getGolemPattern().getWidth(); ++j) {
                for (int k = 0; k < this.getGolemPattern().getHeight(); ++k) {
                    BlockInWorld cachedblockinfo2 = blockpattern$patternhelper.getBlock(j, k, 0);
                    world.setBlock(cachedblockinfo2.getPos(), Blocks.AIR.defaultBlockState(), 2);
                    world.globalLevelEvent(2001, cachedblockinfo2.getPos(), Block.getId((BlockState)cachedblockinfo2.getState()));
                }
            }
            BlockPos spawnPos = blockpattern$patternhelper.getBlock(1, 2, 0).getPos();
            MetalGolem golem = (MetalGolem)MobZEntities.METALGOLEM.get().create(world);
            golem.moveTo(spawnPos, 0.0f, 0.0f);
            world.addFreshEntity((Entity)golem);
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.isClientSide) {
            return;
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"block.mobz.hardened_metal_block.tooltip"));
    }
}

