/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mobz.block.AbstractHead;
import net.mobz.init.MobZBlocks;

public class EnderHeader
extends AbstractHead {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public EnderHeader(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static boolean isValid(Level world, BlockPos pos, BlockState state) {
        if (state.getBlock() != MobZBlocks.ENDER_HEADER.get()) {
            return false;
        }
        BlockState bottom = world.getBlockState(pos.below(2));
        BlockState top1 = world.getBlockState(pos.below().east());
        BlockState top2 = world.getBlockState(pos.below());
        BlockState top3 = world.getBlockState(pos.below().west());
        BlockState head1 = world.getBlockState(pos.east());
        BlockState head2 = world.getBlockState(pos);
        BlockState head3 = world.getBlockState(pos.west());
        if (bottom.getBlock() == Blocks.SOUL_SAND && top1.getBlock() == Blocks.SOUL_SAND && top2.getBlock() == Blocks.SOUL_SAND && top3.getBlock() == Blocks.SOUL_SAND && head1.getBlock() == MobZBlocks.ENDER_HEADER.get() && head2.getBlock() == MobZBlocks.ENDER_HEADER.get() && head3.getBlock() == MobZBlocks.ENDER_HEADER.get()) {
            world.removeBlock(pos, false);
            world.removeBlock(pos.east(), false);
            world.removeBlock(pos.west(), false);
            world.removeBlock(pos.below(2), false);
            world.removeBlock(pos.below().east(), false);
            world.removeBlock(pos.below(), false);
            world.removeBlock(pos.below().west(), false);
            return true;
        }
        BlockState top4 = world.getBlockState(pos.below().north());
        BlockState top5 = world.getBlockState(pos.below().south());
        BlockState head4 = world.getBlockState(pos.north());
        BlockState head5 = world.getBlockState(pos.south());
        if (bottom.getBlock() == Blocks.SOUL_SAND && top4.getBlock() == Blocks.SOUL_SAND && top2.getBlock() == Blocks.SOUL_SAND && top5.getBlock() == Blocks.SOUL_SAND && head4.getBlock() == MobZBlocks.ENDER_HEADER.get() && head2.getBlock() == MobZBlocks.ENDER_HEADER.get() && head5.getBlock() == MobZBlocks.ENDER_HEADER.get()) {
            world.removeBlock(pos, false);
            world.removeBlock(pos.north(), false);
            world.removeBlock(pos.south(), false);
            world.removeBlock(pos.below(2), false);
            world.removeBlock(pos.below().north(), false);
            world.removeBlock(pos.below(), false);
            world.removeBlock(pos.below().south(), false);
            return true;
        }
        return false;
    }
}

