/*
 * Decompiled with CFR 0.152.
 */
package net.mobz;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;

public interface IAbstractedAPI {
    public <T extends Item> Supplier<T> registerItem(String var1, @Nullable CreativeModeTab var2, Function<Item.Properties, T> var3, @Nullable Consumer<T> var4);

    public <T extends Block> Supplier<T> registerBlock(String var1, CreativeModeTab var2, Function<BlockBehaviour.Properties, T> var3, BiFunction<T, Item.Properties, BlockItem> var4, Consumer<T> var5);

    public <E extends Entity, T extends EntityType<E>> Supplier<T> registerEntityType(String var1, Supplier<T> var2, Supplier<AttributeSupplier.Builder> var3, @Nullable Consumer<T> var4);

    public Supplier<Holder<SoundEvent>> registerSound(String var1, ResourceLocation var2, Consumer<SoundEvent> var3);

    default public Supplier<Holder<SoundEvent>> registerSound(String modid, String name) {
        ResourceLocation resLoc = ResourceLocation.tryBuild((String)modid, (String)name);
        return this.registerSound(name, resLoc, null);
    }

    public CreativeModeTab tab(ResourceLocation var1, Supplier<ItemStack> var2);

    public Supplier<SpawnEggItem> spawnEggOf(Supplier<? extends EntityType<? extends Mob>> var1, int var2, int var3, Item.Properties var4);

    public Supplier<MobBucketItem> newMobBucketItem(Supplier<? extends EntityType<?>> var1, Supplier<? extends Fluid> var2, Supplier<? extends SoundEvent> var3, Item.Properties var4);

    public FoodProperties getFoodProperties(ItemStack var1, LivingEntity var2);
}

