/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.entities.nonliving.vanilla.TridentEntityJS;
import net.liopyu.entityjs.item.ProjectileItemBuilder;
import net.liopyu.entityjs.item.TridentItemJS;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class TridentItemBuilder
extends ProjectileItemBuilder {
    public transient Holder<SoundEvent> throwSound;
    public transient Holder<SoundEvent> riptide1Sound;
    public transient Holder<SoundEvent> riptide2Sound;
    public transient Holder<SoundEvent> riptide3Sound;

    public TridentItemBuilder(ResourceLocation i, BuilderBase<?> parent) {
        super(i, parent);
        this.maxDamage = 250;
        this.throwSound = SoundEvents.TRIDENT_THROW;
        this.projectileVelocity = 0.0f;
        this.riptide1Sound = SoundEvents.TRIDENT_RIPTIDE_1;
        this.riptide2Sound = SoundEvents.TRIDENT_RIPTIDE_2;
        this.riptide3Sound = SoundEvents.TRIDENT_RIPTIDE_3;
        this.use = (p, l, h) -> true;
        this.maxStackSize = 1;
        this.useAnimation(UseAnim.SPEAR);
        ResourceLocation tag = ItemTags.DURABILITY_ENCHANTABLE.location();
        ResourceLocation tag2 = ItemTags.TRIDENT_ENCHANTABLE.location();
        ResourceLocation tag3 = Tags.Items.TOOLS_SPEAR.location();
        ResourceLocation tag4 = ItemTags.VANISHING_ENCHANTABLE.location();
        ResourceLocation tag5 = Tags.Items.RANGED_WEAPON_TOOLS.location();
        ResourceLocation tag6 = Tags.Items.MELEE_WEAPON_TOOLS.location();
        ResourceLocation tag7 = Tags.Items.ENCHANTABLES.location();
        this.tag(new ResourceLocation[]{tag, tag2, tag3, tag4, tag5, tag6, tag7});
    }

    @Info(value="Sets the sound event for the riptide level 3")
    public void setRiptide3Sound(SoundEvent riptide3Sound) {
        this.riptide3Sound = Holder.direct((Object)riptide3Sound);
    }

    @Info(value="Sets the sound event for the riptide level 2")
    public void setRiptide2Sound(SoundEvent riptide2Sound) {
        this.riptide2Sound = Holder.direct((Object)riptide2Sound);
    }

    @Info(value="Sets the sound event for the riptide level 1")
    public void setRiptide1Sound(SoundEvent riptide1Sound) {
        this.riptide1Sound = Holder.direct((Object)riptide1Sound);
    }

    @Info(value="Sets the sound event for throwing the item")
    public void setThrowSound(SoundEvent throwSound) {
        this.throwSound = Holder.direct((Object)throwSound);
    }

    @Override
    public Item createObject() {
        return new TridentItemJS(this.createItemProperties(), this.parent){

            public void releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
                if (TridentItemBuilder.this.releaseUsing != null) {
                    TridentItemBuilder.this.releaseUsing.releaseUsing(p_43394_, p_43395_, p_43396_, p_43397_);
                }
                if (p_43396_ instanceof Player) {
                    float f;
                    Player player = (Player)p_43396_;
                    int i = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
                    if (!(i < 10 || (f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)p_43394_, (LivingEntity)player)) > 0.0f && !player.isInWaterOrRain() || 1.isTooDamagedToUse((ItemStack)p_43394_))) {
                        Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)p_43394_, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                        Holder<SoundEvent> sound = SoundEvents.TRIDENT_RIPTIDE_3 == holder.value() ? TridentItemBuilder.this.riptide3Sound : (SoundEvents.TRIDENT_RIPTIDE_2 == holder.value() ? TridentItemBuilder.this.riptide2Sound : (SoundEvents.TRIDENT_RIPTIDE_1 == holder.value() ? TridentItemBuilder.this.riptide1Sound : TridentItemBuilder.this.throwSound));
                        if (!p_43395_.isClientSide) {
                            p_43394_.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)p_43396_.getUsedItemHand()));
                            if (f == 0.0f) {
                                float pZ = TridentItemBuilder.this.projectileZ;
                                float pVelocity = TridentItemBuilder.this.projectileVelocity;
                                float pInaccuracy = TridentItemBuilder.this.projectileInaccuracy;
                                TridentEntityJS throwntrident = new TridentEntityJS((TridentJSBuilder)TridentItemBuilder.this.parent, (EntityType<? extends TridentEntityJS>)((EntityType)TridentItemBuilder.this.parent.get()), p_43396_, p_43395_, p_43394_);
                                throwntrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), pZ, 2.5f + pVelocity, pInaccuracy);
                                if (player.hasInfiniteMaterials()) {
                                    throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                                }
                                p_43395_.addFreshEntity((Entity)throwntrident);
                                p_43395_.playSound(null, (Entity)throwntrident, (SoundEvent)sound.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                                if (!player.hasInfiniteMaterials()) {
                                    player.getInventory().removeItem(p_43394_);
                                }
                            }
                        }
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        if (f > 0.0f) {
                            float f7 = player.getYRot();
                            float f1 = player.getXRot();
                            float f2 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                            float f3 = -Mth.sin((float)(f1 * ((float)Math.PI / 180)));
                            float f4 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f1 * ((float)Math.PI / 180)));
                            float f5 = Mth.sqrt((float)(f2 * f2 + f3 * f3 + f4 * f4));
                            player.push((double)(f2 *= f / f5), (double)(f3 *= f / f5), (double)(f4 *= f / f5));
                            player.startAutoSpinAttack(20, 8.0f, p_43394_);
                            if (player.onGround()) {
                                float f6 = 1.1999999f;
                                player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                            }
                            p_43395_.playSound(null, (Entity)player, (SoundEvent)sound.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                }
            }

            public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand p_43407_) {
                if (TridentItemBuilder.this.use != null && TridentItemBuilder.this.use.use(pLevel, pPlayer, p_43407_)) {
                    ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)p_43407_);
                }
                ItemStack itemstack = pPlayer.getItemInHand(p_43407_);
                if (TridentItemBuilder.this.canThrow) {
                    if (!pLevel.isClientSide) {
                        float pZ = TridentItemBuilder.this.projectileZ;
                        float pVelocity = TridentItemBuilder.this.projectileVelocity;
                        float pInaccuracy = TridentItemBuilder.this.projectileInaccuracy;
                        BuilderBase builderBase = TridentItemBuilder.this.parent;
                        if (builderBase instanceof TridentJSBuilder) {
                            TridentJSBuilder builder = (TridentJSBuilder)builderBase;
                            TridentEntityJS $$4 = new TridentEntityJS(builder, (EntityType<? extends TridentEntityJS>)((EntityType)builder.get()), (LivingEntity)pPlayer, pLevel, itemstack);
                            $$4.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), pZ, pVelocity, pInaccuracy);
                            pLevel.addFreshEntity((Entity)$$4);
                        }
                    }
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                    if (!pPlayer.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
                }
                return super.use(pLevel, pPlayer, p_43407_);
            }
        };
    }
}

