/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class SpawnEggItemBuilder
extends ItemBuilder {
    public transient int backgroundColor = -1;
    public transient int highlightColor = -1;
    public final transient BuilderBase<?> parent;

    public SpawnEggItemBuilder(ResourceLocation i, BuilderBase<?> parent) {
        super(i);
        this.parent = parent;
    }

    @Info(value="Sets the background color of the egg item")
    public SpawnEggItemBuilder backgroundColor(int i) {
        this.backgroundColor = i;
        return this;
    }

    @Info(value="Sets the highlight color of the egg item")
    public SpawnEggItemBuilder highlightColor(int i) {
        this.highlightColor = i;
        return this;
    }

    public Item createObject() {
        return new DeferredSpawnEggItem(this.parent, this.backgroundColor, this.highlightColor, this.createItemProperties());
    }

    public void generateAssets(KubeAssetGenerator generator) {
        generator.itemModel(this.id, m -> {
            if (this.modelGenerator != null) {
                this.modelGenerator.accept(m);
                return;
            }
            if (this.parentModel != null) {
                m.parent(this.parentModel);
                if (this.textures.isEmpty()) {
                    this.texture(this.newID("item/", "").toString());
                }
                m.textures(this.textures);
            } else {
                m.parent(ResourceLocation.parse((String)"minecraft:item/template_spawn_egg"));
                if (!this.textures.isEmpty()) {
                    m.textures(this.textures);
                }
            }
        });
    }
}

