/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs;

import com.mojang.logging.LogUtils;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.registry.BuilderFactory;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import java.lang.reflect.Method;
import net.liopyu.entityjs.builders.living.entityjs.AnimalEntityJSBuilder;
import net.liopyu.entityjs.builders.living.entityjs.BaseLivingEntityJSBuilder;
import net.liopyu.entityjs.builders.living.entityjs.MobEntityJSBuilder;
import net.liopyu.entityjs.builders.living.entityjs.TameableMobJSBuilder;
import net.liopyu.entityjs.builders.living.entityjs.WaterEntityJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.AllayJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.AxolotlJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.BatJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.BeeJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.BlazeJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.CamelJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.CatJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.ChickenJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.CowJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.CreeperJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.DolphinJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.DonkeyJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.EnderManJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.EvokerJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.GhastJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.GoatJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.GuardianJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.HorseJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.IllusionerJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.IronGolemJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.PandaJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.ParrotJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.PiglinJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.SkeletonJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.SlimeJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.WitherJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.WolfJSBuilder;
import net.liopyu.entityjs.builders.living.vanilla.ZombieJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.BaseEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileAnimatableJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatJSBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderJSBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EntityJSUtils;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class EntityJSPlugin
implements KubeJSPlugin {
    public static final Logger LOGGER = LogUtils.getLogger();

    public void registerBuilderTypes(BuilderTypeRegistry registry) {
        registry.of(Registries.ENTITY_TYPE, reg -> {
            boolean useRL = !EntityJSHelperClass.isLegacyKubeJS();
            EntityJSPlugin.addType(reg, "entityjs:nonliving", BaseEntityJSBuilder.class, BaseEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:living", BaseLivingEntityJSBuilder.class, BaseLivingEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:mob", MobEntityJSBuilder.class, MobEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:animal", AnimalEntityJSBuilder.class, AnimalEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:watercreature", WaterEntityJSBuilder.class, WaterEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:tamable", TameableMobJSBuilder.class, TameableMobJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:arrow", ArrowEntityJSBuilder.class, ArrowEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:projectile", ProjectileEntityJSBuilder.class, ProjectileEntityJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "entityjs:geckolib_projectile", ProjectileAnimatableJSBuilder.class, ProjectileAnimatableJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:zombie", ZombieJSBuilder.class, ZombieJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:allay", AllayJSBuilder.class, AllayJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:axolotl", AxolotlJSBuilder.class, AxolotlJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:bat", BatJSBuilder.class, BatJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:bee", BeeJSBuilder.class, BeeJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:blaze", BlazeJSBuilder.class, BlazeJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:boat", BoatJSBuilder.class, BoatJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:camel", CamelJSBuilder.class, CamelJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:cat", CatJSBuilder.class, CatJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:chicken", ChickenJSBuilder.class, ChickenJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:cow", CowJSBuilder.class, CowJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:creeper", CreeperJSBuilder.class, CreeperJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:dolphin", DolphinJSBuilder.class, DolphinJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:donkey", DonkeyJSBuilder.class, DonkeyJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:enderman", EnderManJSBuilder.class, EnderManJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:evoker", EvokerJSBuilder.class, EvokerJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:ghast", GhastJSBuilder.class, GhastJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:goat", GoatJSBuilder.class, GoatJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:guardian", GuardianJSBuilder.class, GuardianJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:horse", HorseJSBuilder.class, HorseJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:illusioner", IllusionerJSBuilder.class, IllusionerJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:iron_golem", IronGolemJSBuilder.class, IronGolemJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:panda", PandaJSBuilder.class, PandaJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:parrot", ParrotJSBuilder.class, ParrotJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:eye_of_ender", EyeOfEnderJSBuilder.class, EyeOfEnderJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:piglin", PiglinJSBuilder.class, PiglinJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:wither", WitherJSBuilder.class, WitherJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:slime", SlimeJSBuilder.class, SlimeJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:wolf", WolfJSBuilder.class, WolfJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:skeleton", SkeletonJSBuilder.class, SkeletonJSBuilder::new, useRL);
            EntityJSPlugin.addType(reg, "minecraft:trident", TridentJSBuilder.class, TridentJSBuilder::new, useRL);
        });
    }

    private static void addType(Object reg, String id, Class<?> builderClass, BuilderFactory factory, boolean useRL) {
        try {
            Method m = reg.getClass().getDeclaredMethod("add", useRL ? ResourceLocation.class : String.class, Class.class, BuilderFactory.class);
            m.setAccessible(true);
            String key = useRL ? ResourceLocation.parse((String)id) : id;
            m.invoke(reg, key, builderClass, factory);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerBindings(BindingRegistry event) {
        event.add("EntityJSUtils", EntityJSUtils.class);
    }

    public void registerEvents(EventGroupRegistry registry) {
        registry.register(EventHandlers.EntityJSEvents);
    }
}

