/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.neoforge;

import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.config.HauntFurnaceConfig;
import com.jship.hauntfurnace.data.neoforge.FuelData;
import com.jship.hauntfurnace.energy.neoforge.EnergyStorageFactoryNeoforge;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@Mod(value="hauntfurnace")
public class HauntFurnaceNeoforge {
    public HauntFurnaceNeoforge(IEventBus modEventBus) {
        HauntFurnace.init();
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerFuelMaps);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> HauntFurnaceConfig.createConfig(parent));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        HauntFurnace.ENERGY_STORAGE_FACTORY = EnergyStorageFactoryNeoforge::new;
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)HauntFurnace.ModBlocks.HAUNT_FURNACE.get());
            event.accept((ItemLike)HauntFurnace.ModBlocks.POWERED_HAUNT_FURNACE.get());
            event.accept((ItemLike)HauntFurnace.ModBlocks.ENDER_FURNACE.get());
            event.accept((ItemLike)HauntFurnace.ModBlocks.POWERED_ENDER_FURNACE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept((ItemLike)HauntFurnace.ModBlocks.GILDED_END_STONE.get());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.POWERED_HAUNT_FURNACE.get(), (blockEntity, context) -> (EnergyStorage)blockEntity.energyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.HAUNT_FURNACE.get(), (blockEntity, side) -> new SidedInvWrapper((WorldlyContainer)blockEntity, side));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.POWERED_HAUNT_FURNACE.get(), (blockEntity, side) -> new SidedInvWrapper((WorldlyContainer)blockEntity, side));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.POWERED_ENDER_FURNACE.get(), (blockEntity, context) -> (EnergyStorage)blockEntity.energyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.ENDER_FURNACE.get(), (blockEntity, side) -> new SidedInvWrapper((WorldlyContainer)blockEntity, side));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)HauntFurnace.ModBlockEntities.POWERED_ENDER_FURNACE.get(), (blockEntity, side) -> new SidedInvWrapper((WorldlyContainer)blockEntity, side));
    }

    private void registerFuelMaps(RegisterDataMapTypesEvent event) {
        event.register(FuelData.HAUNT_FUEL_MAP);
        event.register(FuelData.ENDER_FUEL_MAP);
    }
}

