/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.menu;

import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.block.entity.PoweredEnderFurnaceBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class PoweredEnderFurnaceMenu
extends RecipeBookMenu<SingleRecipeInput, AbstractCookingRecipe> {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int CRAFT_SLOTS = 2;
    public static final int INVENTORY_SLOTS = 29;
    public static final int TOTAL_SLOTS = 38;
    private final Container container;
    private final ContainerData dataAccess;
    protected final Level level;
    private final RecipeBookType recipeBookType = RecipeBookType.FURNACE;

    public PoweredEnderFurnaceMenu(int syncId, Inventory inventory) {
        this(syncId, inventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(3));
    }

    public PoweredEnderFurnaceMenu(int syncId, Inventory inventory, Container container, ContainerData dataAccess) {
        super((MenuType)HauntFurnace.ModMenus.POWERED_ENDER_FURNACE.get(), syncId);
        int i;
        PoweredEnderFurnaceMenu.checkContainerSize((Container)container, (int)2);
        PoweredEnderFurnaceMenu.checkContainerDataCount((ContainerData)dataAccess, (int)3);
        this.container = container;
        this.dataAccess = dataAccess;
        this.level = inventory.player.level();
        this.addSlot(new Slot(container, 0, 56, 35));
        this.addSlot((Slot)new FurnaceResultSlot(inventory.player, container, 1, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.addDataSlots(dataAccess);
    }

    public void fillCraftSlotsStackedContents(StackedContents stackedContents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(stackedContents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<AbstractCookingRecipe> recipe) {
        return ((AbstractCookingRecipe)recipe.value()).matches(new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return 1;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 2;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2 != null && slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot == 1) {
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onQuickCraft(itemStack2, itemStack);
            } else if (slot != 0 ? (this.isHauntable(itemStack2) ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (slot >= 2 && slot < 29 ? !this.moveItemStackTo(itemStack2, 29, 38, false) : slot >= 29 && slot < 38 && !this.moveItemStackTo(itemStack2, 2, 29, false))) : !this.moveItemStackTo(itemStack2, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot2.onTake(player, itemStack2);
        }
        return itemStack;
    }

    protected boolean isHauntable(ItemStack itemStack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)HauntFurnace.ModRecipes.CORRUPTING.get(), (RecipeInput)new SingleRecipeInput(itemStack), this.level).isPresent();
    }

    public int getCookProgress() {
        int i = this.dataAccess.get(1);
        int j = this.dataAccess.get(2);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isBurning() {
        return this.dataAccess.get(1) > 0;
    }

    public int energyLevel() {
        return 32 * this.dataAccess.get(0) / PoweredEnderFurnaceBlockEntity.ENERGY_CAPACITY;
    }

    public int energy() {
        return this.dataAccess.get(0);
    }

    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    public boolean shouldMoveToInventory(int index) {
        return index != 1;
    }
}

