/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.rei.fabric;

import com.jship.hauntfurnace.client.compat.rei.fabric.HauntFurnaceREI;
import com.jship.hauntfurnace.recipe.CorruptingRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CorruptingRecipeDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    RecipeHolder<?> recipe;
    private float xp;
    private int cookTime;

    public CorruptingRecipeDisplay(RecipeHolder<CorruptingRecipe> recipe) {
        this(EntryIngredients.ofIngredients((List)((CorruptingRecipe)recipe.value()).getIngredients()), Collections.singletonList(EntryIngredients.of((ItemStack)((CorruptingRecipe)recipe.value()).getResultItem(null))), recipe, ((CorruptingRecipe)recipe.value()).getExperience(), ((CorruptingRecipe)recipe.value()).getCookingTime());
    }

    public CorruptingRecipeDisplay(List<EntryIngredient> input, List<EntryIngredient> output, CompoundTag tag) {
        this(input, output, RecipeManagerContext.getInstance().byId(tag, "location"), tag.getFloat("xp"), tag.getInt("cookTime"));
    }

    public CorruptingRecipeDisplay(List<EntryIngredient> input, List<EntryIngredient> output, RecipeHolder<?> recipe, float xp, int cookTime) {
        super(input, output, Optional.ofNullable(recipe).map(RecipeHolder::id));
        this.recipe = recipe;
        this.xp = xp;
        this.cookTime = cookTime;
    }

    public float getXp() {
        return this.xp;
    }

    public double getCookingTime() {
        return this.cookTime;
    }

    public int getWidth() {
        return 1;
    }

    public int getHeight() {
        return 1;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return HauntFurnaceREI.CORRUPTING;
    }

    public static <R extends CorruptingRecipeDisplay> BasicDisplay.Serializer<R> serializer(BasicDisplay.Serializer.RecipeLessConstructor<R> constructor) {
        return BasicDisplay.Serializer.ofRecipeLess(constructor, (display, tag) -> {
            tag.putFloat("xp", display.getXp());
            tag.putDouble("cookTime", display.getCookingTime());
        });
    }
}

