/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.rei.fabric;

import com.google.common.collect.Lists;
import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.client.compat.rei.fabric.BurningAltFireWidget;
import com.jship.hauntfurnace.client.compat.rei.fabric.CorruptingRecipeDisplay;
import com.jship.hauntfurnace.client.compat.rei.fabric.HauntFurnaceREI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;

public class CorruptingRecipeCategory
implements DisplayCategory<CorruptingRecipeDisplay> {
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)HauntFurnace.ModBlocks.HAUNT_FURNACE.get()));
    }

    public Component getTitle() {
        return Component.translatable((String)"hauntfurnace.action.corrupting");
    }

    public List<Widget> setupDisplay(CorruptingRecipeDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double cookingTime = display.getCookingTime();
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(new BurningAltFireWidget(new Rectangle(new Point(startPoint.x + 1, startPoint.y + 20), new Dimension(14, 14)), 2).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (Component)Component.translatable((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.getXp()), df.format(cookingTime / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(cookingTime));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(CorruptingRecipeDisplay display) {
        return SimpleDisplayRenderer.from(Collections.singletonList((EntryIngredient)display.getInputEntries().get(0)), (List)display.getOutputEntries());
    }

    public int getDisplayHeight() {
        return 49;
    }

    public CategoryIdentifier<? extends CorruptingRecipeDisplay> getCategoryIdentifier() {
        return HauntFurnaceREI.CORRUPTING;
    }
}

