/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.rei.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class BurningAltFireWidget
extends BurningFire {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hauntfurnace", (String)"textures/gui/container/rei_display.png");
    public static final ResourceLocation TEXTURE_DARK = ResourceLocation.fromNamespaceAndPath((String)"hauntfurnace", (String)"textures/gui/container/rei_display_dark.png");
    private final int fireShift;
    private Rectangle bounds;
    private double animationDuration = -1.0;
    private final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public BurningAltFireWidget(Rectangle bounds, int fireShift) {
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
        this.fireShift = fireShift;
    }

    public double getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(guiGraphics, false, 1.0f);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
            this.renderBackground(guiGraphics, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, boolean dark, float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.getAnimationDuration() > 0.0) {
            int height = 14 - Mth.ceil((double)((double)System.currentTimeMillis() / (this.animationDuration / 14.0) % 14.0));
            guiGraphics.blit(dark ? TEXTURE_DARK : TEXTURE, this.getX(), this.getY(), 1, 74, 14, 14 - height);
            guiGraphics.blit(dark ? TEXTURE_DARK : TEXTURE, this.getX(), this.getY() + 14 - height, 82 + 14 * this.fireShift, 77 + (14 - height), 14, height);
        } else {
            guiGraphics.blit(dark ? TEXTURE_DARK : TEXTURE, this.getX(), this.getY(), 1, 74, 14, 14);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

