/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.client.compat.jei.HauntFurnaceJEI;
import com.jship.hauntfurnace.recipe.HauntingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HauntingRecipeCategory
implements IRecipeCategory<HauntingRecipe> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hauntfurnace", (String)"textures/gui/container/jei_gui.png");
    private final IDrawable background;
    private final IDrawableStatic staticFlame;
    private final IDrawableAnimated animatedFlame;
    private final int regularCookTime;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public HauntingRecipeCategory(final IGuiHelper guiHelper) {
        this.staticFlame = guiHelper.createDrawable(TEXTURE, 96, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.background = guiHelper.createDrawable(TEXTURE, 0, 114, 82, 54);
        this.regularCookTime = 200;
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)HauntFurnace.ModBlocks.HAUNT_FURNACE.get()));
        this.localizedName = Component.translatable((String)"hauntfurnace.action.haunting");
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(TEXTURE, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    private IDrawableAnimated getArrow(HauntingRecipe recipe) {
        double cookTime = recipe.getCookingTime();
        if (cookTime <= 0.0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)((int)cookTime));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(HauntingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(guiGraphics, 24, 18);
        this.drawExperience(recipe, guiGraphics, 0);
        this.drawCookTime(recipe, guiGraphics, 45);
    }

    private void drawExperience(HauntingRecipe recipe, GuiGraphics guiGraphics, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)experienceString);
            guiGraphics.drawString(font, (Component)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    private void drawCookTime(HauntingRecipe recipe, GuiGraphics guiGraphics, int y) {
        double cookTime = recipe.getCookingTime();
        if (cookTime > 0.0) {
            int cookTimeSeconds = (int)cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            guiGraphics.drawString(font, (Component)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public RecipeType<HauntingRecipe> getRecipeType() {
        return HauntFurnaceJEI.HAUNTING_RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HauntingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(recipe.getResultItem(null));
    }
}

