/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.jei;

import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.client.compat.jei.CorruptingRecipeCategory;
import com.jship.hauntfurnace.client.compat.jei.HauntingRecipeCategory;
import com.jship.hauntfurnace.recipe.CorruptingRecipe;
import com.jship.hauntfurnace.recipe.HauntingRecipe;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JeiPlugin
public class HauntFurnaceJEI
implements IModPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HauntFurnaceJEI.class);
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hauntfurnace", (String)"jei_plugin");
    public static final RecipeType<HauntingRecipe> HAUNTING_RECIPE_TYPE = RecipeType.create((String)"hauntfurnace", (String)"haunting", HauntingRecipe.class);
    public static final RecipeType<CorruptingRecipe> CORRUPTING_RECIPE_TYPE = RecipeType.create((String)"hauntfurnace", (String)"corrupting", CorruptingRecipe.class);

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new HauntingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CorruptingRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List hauntingRecipeHolders = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)HauntFurnace.ModRecipes.HAUNTING.get());
        ArrayList<HauntingRecipe> hauntingRecipes = new ArrayList<HauntingRecipe>();
        for (RecipeHolder recipeHolder : hauntingRecipeHolders) {
            hauntingRecipes.add((HauntingRecipe)recipeHolder.value());
        }
        registration.addRecipes(HAUNTING_RECIPE_TYPE, hauntingRecipes);
        log.info("[Haunt Furnace] Registered haunting recipes: {}", (Object)hauntingRecipes.size());
        List corruptingRecipeHolders = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)HauntFurnace.ModRecipes.CORRUPTING.get());
        ArrayList<CorruptingRecipe> corruptingRecipes = new ArrayList<CorruptingRecipe>();
        for (RecipeHolder recipeHolder : corruptingRecipeHolders) {
            corruptingRecipes.add((CorruptingRecipe)recipeHolder.value());
        }
        registration.addRecipes(CORRUPTING_RECIPE_TYPE, corruptingRecipes);
        log.info("[Haunt Furnace] Registered corrupting recipes: {}", (Object)corruptingRecipes.size());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)HauntFurnace.ModBlocks.HAUNT_FURNACE.get()), new RecipeType[]{HAUNTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)HauntFurnace.ModBlocks.POWERED_HAUNT_FURNACE.get()), new RecipeType[]{HAUNTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)HauntFurnace.ModBlocks.ENDER_FURNACE.get()), new RecipeType[]{CORRUPTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)HauntFurnace.ModBlocks.POWERED_ENDER_FURNACE.get()), new RecipeType[]{CORRUPTING_RECIPE_TYPE});
    }
}

