/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.emi;

import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.client.compat.emi.CorruptingEMIRecipe;
import com.jship.hauntfurnace.client.compat.emi.HauntingEMIRecipe;
import com.jship.hauntfurnace.recipe.CorruptingRecipe;
import com.jship.hauntfurnace.recipe.HauntingRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class HauntFurnaceEMI
implements EmiPlugin {
    public static final ResourceLocation SPRITE_SHEET = HauntFurnace.id("textures/gui/container/jei_gui.png");
    public static final EmiStack HAUNT_FURNACE_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)HauntFurnace.ModBlocks.HAUNT_FURNACE.get()));
    public static final EmiStack POWERED_HAUNT_FURNACE_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)HauntFurnace.ModBlocks.POWERED_HAUNT_FURNACE.get()));
    public static final EmiRecipeCategory HAUNTING_CATEGORY = new EmiRecipeCategory(HauntFurnace.id("haunt_furnace"), (EmiRenderable)HAUNT_FURNACE_WORKSTATION, (EmiRenderable)HAUNT_FURNACE_WORKSTATION, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiStack ENDER_FURNACE_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)HauntFurnace.ModBlocks.ENDER_FURNACE.get()));
    public static final EmiStack POWERED_ENDER_FURNACE_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)HauntFurnace.ModBlocks.POWERED_ENDER_FURNACE.get()));
    public static final EmiRecipeCategory CORRUPTING_CATEGORY = new EmiRecipeCategory(HauntFurnace.id("ender_furnace"), (EmiRenderable)ENDER_FURNACE_WORKSTATION, (EmiRenderable)ENDER_FURNACE_WORKSTATION, EmiRecipeSorting.compareOutputThenInput());

    public void register(EmiRegistry registry) {
        registry.addCategory(HAUNTING_CATEGORY);
        registry.addWorkstation(HAUNTING_CATEGORY, (EmiIngredient)HAUNT_FURNACE_WORKSTATION);
        registry.addWorkstation(HAUNTING_CATEGORY, (EmiIngredient)POWERED_HAUNT_FURNACE_WORKSTATION);
        registry.addCategory(CORRUPTING_CATEGORY);
        registry.addWorkstation(CORRUPTING_CATEGORY, (EmiIngredient)ENDER_FURNACE_WORKSTATION);
        registry.addWorkstation(CORRUPTING_CATEGORY, (EmiIngredient)POWERED_ENDER_FURNACE_WORKSTATION);
        RecipeManager recipeManager = registry.getRecipeManager();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor((RecipeType)HauntFurnace.ModRecipes.HAUNTING.get())) {
            registry.addRecipe((EmiRecipe)new HauntingEMIRecipe((HauntingRecipe)recipe.value()));
        }
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor((RecipeType)HauntFurnace.ModRecipes.CORRUPTING.get())) {
            registry.addRecipe((EmiRecipe)new CorruptingEMIRecipe((CorruptingRecipe)recipe.value()));
        }
    }
}

