/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.client.compat.emi;

import com.jship.hauntfurnace.client.compat.emi.HauntFurnaceEMI;
import com.jship.hauntfurnace.recipe.CorruptingRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CorruptingEMIRecipe
extends BasicEmiRecipe {
    private final CorruptingRecipe recipe;

    CorruptingEMIRecipe(CorruptingRecipe recipe) {
        super(HauntFurnaceEMI.CORRUPTING_CATEGORY, ResourceLocation.fromNamespaceAndPath((String)"hauntfurnace", (String)"/corrupting"), 70, 18);
        this.recipe = recipe;
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(0))));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem(null)));
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, 50 * this.recipe.getCookingTime()).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.recipe.getCookingTime() / 20.0f)}).getVisualOrderText())));
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
        widgets.addAnimatedTexture(new EmiTexture(HauntFurnaceEMI.SPRITE_SHEET, 110, 114, 14, 14), 1, 24, 4000, false, true, true);
        widgets.addText((Component)Component.translatable((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.recipe.getExperience())}), 26, 28, -1, true);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 58, 0).recipeContext((EmiRecipe)this);
    }
}

