/*
 * Decompiled with CFR 0.152.
 */
package com.jship.hauntfurnace.block.entity;

import com.google.common.collect.Lists;
import com.jship.hauntfurnace.HauntFurnace;
import com.jship.hauntfurnace.block.PoweredHauntFurnaceBlock;
import com.jship.hauntfurnace.config.HauntFurnaceConfig;
import com.jship.hauntfurnace.energy.EnergyStorageWrapper;
import com.jship.hauntfurnace.menu.PoweredHauntFurnaceMenu;
import com.jship.hauntfurnace.recipe.HauntingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PoweredHauntFurnaceBlockEntity
extends BlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
MenuProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int SLOT_COUNT = 2;
    public static final int[] SLOTS_FOR_UP = new int[]{0, 1};
    public static final int[] SLOTS_FOR_DOWN = new int[]{0, 1};
    public static final int[] SLOTS_FOR_SIDES = new int[]{0, 1};
    public static final int ENERGY_STORAGE_PROPERTY_INDEX = 0;
    public static final int COOK_TIME_PROPERTY_INDEX = 1;
    public static final int COOK_TIME_TOTAL_PROPERTY_INDEX = 2;
    public static final int PROPERTY_COUNT = 3;
    public static final int DEFAULT_COOK_TIME = 100;
    private static final int ENERGY_USAGE_PER_TICK = HauntFurnaceConfig.hauntEnergyUsage();
    protected NonNullList<ItemStack> items;
    public static final int ENERGY_CAPACITY = HauntFurnaceConfig.hauntEnergyCapacity();
    public static final int ENERGY_MAX_INSERT = HauntFurnaceConfig.hauntEnergyMaxInsert();
    public static final int ENERGY_MAX_EXTRACT = ENERGY_USAGE_PER_TICK;
    public final EnergyStorageWrapper energyStorage;
    private int cookingProgress;
    private int cookingTotalTime;
    private boolean isLit;
    private int unpoweredCount = 0;
    private LockCode lockKey = LockCode.NO_LOCK;
    protected final ContainerData dataAccess;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;

    public PoweredHauntFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HauntFurnace.ModBlockEntities.POWERED_HAUNT_FURNACE.get(), pos, state);
        this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        this.energyStorage = HauntFurnace.ENERGY_STORAGE_FACTORY.get().createEnergyStorage(ENERGY_CAPACITY, ENERGY_MAX_INSERT, ENERGY_MAX_EXTRACT, this);
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                switch (index) {
                    case 0: {
                        return PoweredHauntFurnaceBlockEntity.this.energyStorage.getEnergyStored();
                    }
                    case 1: {
                        return PoweredHauntFurnaceBlockEntity.this.cookingProgress;
                    }
                    case 2: {
                        return PoweredHauntFurnaceBlockEntity.this.cookingTotalTime;
                    }
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        PoweredHauntFurnaceBlockEntity.this.energyStorage.setEnergyStored(value);
                        break;
                    }
                    case 1: {
                        PoweredHauntFurnaceBlockEntity.this.cookingProgress = value;
                        break;
                    }
                    case 2: {
                        PoweredHauntFurnaceBlockEntity.this.cookingTotalTime = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)HauntFurnace.ModRecipes.HAUNTING.get()));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.powered_haunt_furnace");
    }

    public boolean canOpen(Player player) {
        return PoweredHauntFurnaceBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(Player player, LockCode lockCode, Component component) {
        if (!player.isSpectator() && !lockCode.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{component}), true);
            player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new PoweredHauntFurnaceMenu(id, inventory, (Container)this, this.dataAccess);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return this.canOpen(player) ? this.createMenu(i, inventory) : null;
    }

    private boolean isLit() {
        return this.isLit;
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.loadAdditional(compoundTag, registries);
        this.lockKey = LockCode.fromTag((CompoundTag)compoundTag);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)registries);
        this.energyStorage.setEnergyStored(compoundTag.getInt("EnergyStorage"));
        this.cookingProgress = compoundTag.getShort("CookTime");
        this.cookingTotalTime = compoundTag.getShort("CookTimeTotal");
        CompoundTag recipesCompoundTag = compoundTag.getCompound("RecipesUsed");
        recipesCompoundTag.getAllKeys().forEach(recipe -> this.recipesUsed.put((Object)ResourceLocation.parse((String)recipe), recipesCompoundTag.getInt(recipe)));
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider registries) {
        super.saveAdditional(compoundTag, registries);
        this.lockKey.addToTag(compoundTag);
        compoundTag.putInt("EnergyStorage", (int)((short)this.energyStorage.getEnergyStored()));
        compoundTag.putShort("CookTime", (short)this.cookingProgress);
        compoundTag.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)registries);
        CompoundTag recipesCompoundTag = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> recipesCompoundTag.putInt(resourceLocation.toString(), integer.intValue()));
        compoundTag.put("RecipesUsed", (Tag)recipesCompoundTag);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, PoweredHauntFurnaceBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        ItemStack inputItems = blockEntity.getItem(0);
        ItemStack outputItems = blockEntity.getItem(1);
        RecipeHolder recipe = !inputItems.isEmpty() ? (RecipeHolder)blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputItems), level).orElse(null) : null;
        ItemStack recipeOutput = recipe != null ? recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()) : ItemStack.EMPTY;
        boolean canOutput = !recipeOutput.isEmpty() && (outputItems.isEmpty() || ItemStack.isSameItem((ItemStack)recipeOutput, (ItemStack)outputItems) && outputItems.getCount() < blockEntity.getMaxStackSize() && outputItems.getCount() < outputItems.getMaxStackSize());
        boolean isLit = false;
        boolean stateChanged = false;
        if (canOutput && blockEntity.energyStorage.extractEnergy(ENERGY_USAGE_PER_TICK, false) == ENERGY_USAGE_PER_TICK) {
            isLit = true;
            blockEntity.unpoweredCount = 0;
            blockEntity.cookingProgress += 2;
            if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                blockEntity.cookingProgress = 0;
                blockEntity.cookingTotalTime = PoweredHauntFurnaceBlockEntity.getTotalCookTime(level, blockEntity);
                inputItems.shrink(1);
                if (outputItems.isEmpty()) {
                    blockEntity.items.set(1, (Object)recipeOutput.copy());
                } else {
                    outputItems.grow(1);
                }
                blockEntity.setRecipeUsed(recipe);
            }
        } else {
            blockEntity.cookingProgress = canOutput ? Mth.clamp((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime) : 0;
        }
        if (!isLit) {
            ++blockEntity.unpoweredCount;
            if (blockEntity.isLit() && blockEntity.unpoweredCount > 4) {
                stateChanged = true;
                blockEntity.isLit = isLit;
            }
        } else if (!blockEntity.isLit()) {
            stateChanged = true;
            blockEntity.isLit = isLit;
        }
        if (stateChanged) {
            blockState = (BlockState)blockState.setValue((Property)PoweredHauntFurnaceBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.setBlockAndUpdate(blockPos, blockState);
            PoweredHauntFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    private static int getTotalCookTime(Level level, PoweredHauntFurnaceBlockEntity blockEntity) {
        return blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(blockEntity.getItem(0)), level).map(recipe -> ((AbstractCookingRecipe)recipe.value()).getCookingTime()).orElse(100);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public NonNullList<ItemStack> getHeldStacks() {
        return this.items;
    }

    public void setHeldStacks(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(itemStack -> itemStack.isEmpty());
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int i, int j) {
        return ContainerHelper.removeItem(this.items, (int)i, (int)j);
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.items, (int)i);
    }

    public void setItem(int i, ItemStack itemStack) {
        ItemStack itemStack2 = this.getItem(i);
        boolean sameItemAdded = !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack);
        this.items.set(i, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        if (i == 0 && !sameItemAdded) {
            this.cookingTotalTime = PoweredHauntFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int i, ItemStack itemStack) {
        return i == 0;
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(i, itemStack);
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return i == 1;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.id();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeHolder : list) {
            if (recipeHolder == null) continue;
            player.triggerRecipeCrafted(recipeHolder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel serverLevel, Vec3 vec3) {
        ArrayList recipes = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            serverLevel.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                recipes.add(recipe);
                PoweredHauntFurnaceBlockEntity.createExperience(serverLevel, vec3, entry.getIntValue(), ((HauntingRecipe)recipe.value()).getExperience());
            });
        }
        return recipes;
    }

    private static void createExperience(ServerLevel serverLevel, Vec3 vec3, int i, float f) {
        int j = Mth.floor((float)((float)i * f));
        float g = Mth.frac((float)((float)i * f));
        if (g != 0.0f && Math.random() < (double)g) {
            ++j;
        }
        ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)vec3, (int)j);
    }

    public void fillStackedContents(StackedContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.accountStack(itemStack);
        }
    }

    @Nullable
    public EnergyStorageWrapper getEnergyStorage(@Nullable Direction side) {
        return this.energyStorage;
    }
}

